/*
 * Decompiled with CFR 0.152.
 */
package com.ma.entities.constructs.ai;

import com.ma.blocks.tileentities.RunicAnvilTile;
import com.ma.entities.constructs.ai.base.ConstructActions;
import com.ma.entities.constructs.ai.base.ConstructCommandTileEntityInteract;
import com.ma.entities.constructs.animated.EntityAnimatedConstruct;
import com.ma.items.constructs.parts._base.ConstructCapability;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;

public class ConstructRuneforge
extends ConstructCommandTileEntityInteract<TileEntity> {
    private static final ConstructCapability[] requiredCaps = new ConstructCapability[]{ConstructCapability.SMITH};
    private ArrayList<Item> filter;
    private int interactTimer = this.getInteractTime(ConstructCapability.SMITH);

    public ConstructRuneforge(EntityAnimatedConstruct construct) {
        super(construct, TileEntity.class);
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        this.filter = new ArrayList();
    }

    public void setFilterAndContainer(BlockPos container, Direction side, List<Item> filter) {
        this.filter.clear();
        this.filter.addAll(filter);
        this.setTileEntity(container, side);
    }

    @Override
    public boolean func_75250_a() {
        return super.func_75250_a() && this.getTileEntity() instanceof RunicAnvilTile;
    }

    @Override
    public void func_75246_d() {
        super.func_75246_d();
        if (this.getTileEntity() == null || !(this.getTileEntity() instanceof RunicAnvilTile)) {
            this.isFinished = true;
            this.construct.pushDiagnosticMessage(this.translate("mana-and-artifice.constructs.feedback.te_missing", new Object[0]));
            this.construct.field_70714_bg.func_85156_a((Goal)this);
        }
        if (this.doMove()) {
            if (this.interactTimer > 0) {
                --this.interactTimer;
            } else {
                this.interactTimer = this.getInteractTime(ConstructCapability.SMITH);
                this.faceBlockPos(this.blockPos);
                this.preInteract();
                if (this.forgeNext()) {
                    this.isFinished = true;
                    this.construct.field_70714_bg.func_85156_a((Goal)this);
                }
            }
        }
    }

    private boolean forgeNext() {
        RunicAnvilTile te = (RunicAnvilTile)((Object)this.getTileEntity());
        if (te != null) {
            PlayerEntity player = this.getOrCreatePlayer();
            if (player == null) {
                return true;
            }
            if (te.func_70301_a(0).func_190926_b() || te.func_70301_a(1).func_190926_b()) {
                if (!this.isSuccess) {
                    this.construct.pushDiagnosticMessage(this.translate("mana-and-artifice.constructs.feedback.runeforge_missing_items", new Object[0]));
                }
                return true;
            }
            this.construct.getHandWithCapability(ConstructCapability.SMITH).ifPresent(h -> this.construct.func_184609_a((Hand)h));
            int advanceResponse = te.advanceCrafting(player, 5, false);
            if (advanceResponse == 0) {
                this.construct.field_70170_p.func_184148_a(null, this.construct.func_226277_ct_(), this.construct.func_226278_cu_(), this.construct.func_226281_cx_(), SoundEvents.field_187692_g, SoundCategory.BLOCKS, 1.0f, 1.0f);
                return false;
            }
            if (advanceResponse == 4) {
                this.construct.field_70170_p.func_184148_a(null, this.construct.func_226277_ct_(), this.construct.func_226278_cu_(), this.construct.func_226281_cx_(), SoundEvents.field_187692_g, SoundCategory.BLOCKS, 1.0f, 1.0f);
                this.construct.pushDiagnosticMessage(this.translate("mana-and-artifice.constructs.feedback.runeforge_success", this.translate(te.func_70301_a(0))));
                this.isSuccess = true;
            } else if (advanceResponse == 1) {
                this.construct.pushDiagnosticMessage(this.translate("mana-and-artifice.constructs.feedback.runeforge_no_recipe", new Object[0]));
            } else if (advanceResponse == 2) {
                this.construct.pushDiagnosticMessage(this.translate("mana-and-artifice.constructs.feedback.runeforge_low_tier", new Object[0]));
            }
        }
        return true;
    }

    @Override
    public void func_75249_e() {
        super.func_75249_e();
        this.interactTimer = this.getInteractTime(ConstructCapability.SMITH);
    }

    @Override
    public ConstructActions getType() {
        return ConstructActions.RUNEFORGE;
    }

    @Override
    public ConstructCapability[] requiredCapabilities() {
        return requiredCaps;
    }

    @Override
    public Inventory createConfigurationInventory() {
        return new Inventory(1);
    }
}

