/*
 * Decompiled with CFR 0.152.
 */
package com.ma.entities.constructs.ai;

import com.ma.entities.constructs.ai.base.ConstructActions;
import com.ma.entities.constructs.ai.base.ConstructCommand;
import com.ma.entities.constructs.animated.EntityAnimatedConstruct;
import com.ma.items.ItemInit;
import com.ma.items.constructs.parts._base.ConstructCapability;
import com.ma.items.runes.ItemRuneMarking;
import com.ma.tools.math.MathUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;

public class ConstructButcher
extends ConstructCommand {
    private static final int MAX_SIZE = 32;
    private static final int MIN_ANIMALS = 3;
    private static final ConstructCapability[] requiredCaps = new ConstructCapability[]{ConstructCapability.MELEE_ATTACK};
    private int attackTimer = this.getInteractTime(ConstructCapability.MELEE_ATTACK);
    private AxisAlignedBB butcherArea = null;
    private AnimalEntity currentButcherTarget = null;
    private boolean tooBig = false;

    public ConstructButcher(EntityAnimatedConstruct construct) {
        super(construct);
    }

    @Override
    public void func_75246_d() {
        super.func_75246_d();
        if (this.currentButcherTarget == null && !this.locateButcherTarget()) {
            this.construct.pushDiagnosticMessage(this.translate("mana-and-artifice.constructs.feedback.butcher_no_target", new Object[0]), false);
            this.isFinished = true;
            return;
        }
        if (!this.currentButcherTarget.func_70089_S()) {
            this.currentButcherTarget = null;
            this.isFinished = true;
            return;
        }
        this.moveEntityTarget = this.currentButcherTarget;
        if (this.doMove() && this.attackButcherTarget()) {
            this.isFinished = true;
            this.isSuccess = true;
            return;
        }
    }

    private boolean locateButcherTarget() {
        HashMap locatedEntities = new HashMap();
        this.construct.field_70170_p.func_175647_a(AnimalEntity.class, this.butcherArea, e -> e.func_70089_S() && !e.func_70631_g_() && !e.func_70880_s()).forEach(e -> {
            if (!locatedEntities.containsKey(e.func_200600_R())) {
                locatedEntities.put(e.func_200600_R(), new ArrayList<AnimalEntity>(Arrays.asList(e)));
            } else {
                ((List)locatedEntities.get(e.func_200600_R())).add(e);
            }
        });
        Optional<List> target = locatedEntities.entrySet().stream().filter(e -> ((List)e.getValue()).size() >= 3).map(e -> (List)e.getValue()).findAny();
        if (!target.isPresent()) {
            return false;
        }
        List potentials = target.get();
        Optional<Object> potential = potentials.stream().filter(a -> a.func_70874_b() != 0).findAny();
        if (!potential.isPresent() && !(potential = potentials.stream().findAny()).isPresent()) {
            return false;
        }
        this.currentButcherTarget = potential.get();
        this.construct.pushDiagnosticMessage(this.translate("mana-and-artifice.constructs.feedback.butcher_target", this.translate((Entity)this.currentButcherTarget)), false);
        return true;
    }

    private boolean attackButcherTarget() {
        if (this.attackTimer > 0) {
            if (this.attackTimer == 5) {
                this.construct.getHandWithCapability(ConstructCapability.MELEE_ATTACK).ifPresent(h -> this.construct.func_184609_a((Hand)h));
            }
            --this.attackTimer;
            return false;
        }
        this.construct.func_70652_k((Entity)this.currentButcherTarget);
        this.attackTimer = this.getInteractTime(ConstructCapability.MELEE_ATTACK);
        if (!this.currentButcherTarget.func_70089_S()) {
            this.moveEntityTarget = null;
            this.currentButcherTarget = null;
            this.construct.pushDiagnosticMessage(this.translate("mana-and-artifice.constructs.feedback.butcher_attack_success", new Object[0]), false);
            return true;
        }
        return false;
    }

    @Override
    public void func_75251_c() {
        super.func_75251_c();
        this.moveEntityTarget = null;
        this.currentButcherTarget = null;
    }

    @Override
    public boolean func_75250_a() {
        if (!super.func_75250_a()) {
            return false;
        }
        if (this.butcherArea == null) {
            this.construct.pushDiagnosticMessage(this.translate("mana-and-artifice.constructs.feedback.butcher_not_configured", new Object[0]), false);
            return false;
        }
        if (this.tooBig) {
            this.construct.pushDiagnosticMessage(this.translate("mana-and-artifice.constructs.feedback.area_too_big", 32, this.butcherArea.func_216364_b(), this.butcherArea.func_216360_c(), this.butcherArea.func_216362_d()), false);
            return false;
        }
        return true;
    }

    @Override
    public boolean func_75253_b() {
        return super.func_75253_b() && this.func_75250_a();
    }

    @Override
    public ConstructActions getType() {
        return ConstructActions.BUTCHER;
    }

    @Override
    public void copyFrom(ConstructCommand other) {
        if (other instanceof ConstructButcher) {
            this.butcherArea = ((ConstructButcher)other).butcherArea;
            this.currentButcherTarget = ((ConstructButcher)other).currentButcherTarget;
        }
    }

    @Override
    public void readNBT(CompoundNBT nbt) {
    }

    @Override
    protected CompoundNBT writeInternal(CompoundNBT nbt) {
        return nbt;
    }

    @Override
    public void getDataFromInventory(Inventory config) {
        ItemStack firstMark = config.func_70301_a(0);
        ItemStack secondMark = config.func_70301_a(1);
        this.butcherArea = null;
        this.tooBig = false;
        if (firstMark.func_77973_b() == ItemInit.RUNE_MARKING.get() && secondMark.func_77973_b() == ItemInit.RUNE_MARKING.get()) {
            BlockPos firstPos = ((ItemRuneMarking)ItemInit.RUNE_MARKING.get()).getLocation(firstMark);
            BlockPos secondPos = ((ItemRuneMarking)ItemInit.RUNE_MARKING.get()).getLocation(secondMark);
            if (firstPos != null && secondPos != null) {
                this.butcherArea = MathUtils.createInclusiveBB(firstPos, secondPos);
                if (this.butcherArea.func_216364_b() > 32.0 || this.butcherArea.func_216360_c() > 32.0 || this.butcherArea.func_216362_d() > 32.0) {
                    this.tooBig = true;
                    return;
                }
            }
        }
    }

    @Override
    public Inventory createConfigurationInventory() {
        return new Inventory(2);
    }

    @Override
    public ConstructCapability[] requiredCapabilities() {
        return requiredCaps;
    }

    @Override
    public boolean isFullyConfigured() {
        return this.butcherArea != null;
    }
}

