/*
 * Decompiled with CFR 0.152.
 */
package com.ma.capabilities.worlddata;

import com.google.common.collect.ImmutableList;
import com.ma.api.capabilities.IRitualTeleportLocation;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class RitualTeleportLocation
implements IRitualTeleportLocation {
    private static final String KEY_POSITION_X = "position_x";
    private static final String KEY_POSITION_Y = "position_y";
    private static final String KEY_POSITION_Z = "position_z";
    private static final String KEY_WORLD_REG = "world_registry_key";
    private static final String KEY_WORLD_REGTYPE = "world_registry_key_regtype";
    private static final String KEY_DIRECTION = "direction";
    private static final String KEY_REAGENTS = "reagents";
    private static final String KEY_REAGENT_COUNT = "reagent_count";
    private static final String KEY_REAGENT_PREFIX = "reagent_";
    private final BlockPos pos;
    private final Direction direction;
    private final ImmutableList<ResourceLocation> reagents;
    private RegistryKey<World> worldType;

    public RitualTeleportLocation(RegistryKey<World> worldType, BlockPos position, List<ResourceLocation> reagents, Direction direction) {
        this.pos = position;
        this.reagents = ImmutableList.copyOf(reagents);
        this.direction = direction;
        this.worldType = worldType;
    }

    @Override
    public boolean matches(List<ResourceLocation> reagentList) {
        if (reagentList == null || reagentList.size() != this.reagents.size()) {
            return false;
        }
        for (int i = 0; i < reagentList.size(); ++i) {
            ResourceLocation internal = (ResourceLocation)this.reagents.get(i);
            ResourceLocation external = reagentList.get(i);
            if (external == null) {
                return false;
            }
            if (internal.toString().equals(external.toString())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean matches(BlockPos pos) {
        if (pos == null) {
            return false;
        }
        return this.pos.func_177958_n() == pos.func_177958_n() && this.pos.func_177956_o() == pos.func_177956_o() && this.pos.func_177952_p() == pos.func_177952_p();
    }

    public void writeToNBT(CompoundNBT nbt) {
        nbt.func_74776_a(KEY_DIRECTION, this.direction.func_185119_l());
        nbt.func_74768_a(KEY_POSITION_X, this.pos.func_177958_n());
        nbt.func_74768_a(KEY_POSITION_Y, this.pos.func_177956_o());
        nbt.func_74768_a(KEY_POSITION_Z, this.pos.func_177952_p());
        nbt.func_74768_a(KEY_REAGENT_COUNT, this.reagents.size());
        nbt.func_74778_a(KEY_WORLD_REG, this.worldType.getRegistryName().toString());
        nbt.func_74778_a(KEY_WORLD_REGTYPE, this.worldType.func_240901_a_().toString());
        CompoundNBT reagentData = new CompoundNBT();
        for (int i = 0; i < this.reagents.size(); ++i) {
            reagentData.func_74778_a(KEY_REAGENT_PREFIX + i, ((ResourceLocation)this.reagents.get(i)).toString());
        }
        nbt.func_218657_a(KEY_REAGENTS, (INBT)reagentData);
    }

    @Nullable
    public static RitualTeleportLocation fromNBT(CompoundNBT nbt) {
        Direction direction;
        if (!nbt.func_74764_b(KEY_WORLD_REG) || !nbt.func_74764_b(KEY_WORLD_REGTYPE)) {
            return null;
        }
        ResourceLocation regType = new ResourceLocation(nbt.func_74779_i(KEY_WORLD_REGTYPE));
        ResourceLocation regEntry = new ResourceLocation(nbt.func_74779_i(KEY_WORLD_REG));
        RegistryKey key = new RegistryKey(regEntry, regType);
        Direction direction2 = direction = nbt.func_74764_b(KEY_DIRECTION) ? Direction.func_176733_a((double)nbt.func_74760_g(KEY_DIRECTION)) : Direction.NORTH;
        if (!(nbt.func_74764_b(KEY_POSITION_X) && nbt.func_74764_b(KEY_POSITION_Y) && nbt.func_74764_b(KEY_POSITION_Z))) {
            return null;
        }
        BlockPos position = new BlockPos(nbt.func_74762_e(KEY_POSITION_X), nbt.func_74762_e(KEY_POSITION_Y), nbt.func_74762_e(KEY_POSITION_Z));
        ArrayList<ResourceLocation> reagents = new ArrayList<ResourceLocation>();
        if (nbt.func_74764_b(KEY_REAGENT_COUNT) && nbt.func_74764_b(KEY_REAGENTS)) {
            int count = nbt.func_74762_e(KEY_REAGENT_COUNT);
            CompoundNBT subNBT = nbt.func_74775_l(KEY_REAGENTS);
            for (int i = 0; i < count; ++i) {
                if (!subNBT.func_74764_b(KEY_REAGENT_PREFIX + i)) {
                    return null;
                }
                reagents.add(new ResourceLocation(subNBT.func_74779_i(KEY_REAGENT_PREFIX + i)));
            }
        } else {
            return null;
        }
        return new RitualTeleportLocation((RegistryKey<World>)key, position, reagents, direction);
    }

    @Override
    public ImmutableList<ResourceLocation> getReagents() {
        return this.reagents;
    }

    @Override
    public Direction getDirection() {
        return this.direction;
    }

    @Override
    public BlockPos getPos() {
        return this.pos;
    }

    @Override
    public RegistryKey<World> getWorldType() {
        return this.worldType;
    }

    @Override
    public void tryCorrectWorldKey(RegistryKey<World> world) {
        if (this.worldType.toString().equals(world.toString())) {
            this.worldType = world;
        }
    }
}

