/*
 * Decompiled with CFR 0.152.
 */
package com.ma.capabilities.playerdata.progression;

import com.ma.api.capabilities.Faction;
import com.ma.api.capabilities.IPlayerMagic;
import com.ma.api.capabilities.IPlayerProgression;
import com.ma.api.faction.FactionDifficultyStats;
import com.ma.capabilities.playerdata.magic.PlayerMagicProvider;
import com.ma.config.GeneralModConfig;
import com.ma.progression.ProgressionEventHandler;
import com.ma.progression.ProgressionHelper;
import com.ma.tools.math.MathUtils;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;

public class PlayerProgression
implements IPlayerProgression {
    public static final int MAX_TIERS = 5;
    public static final double RAID_IRE = 1.0;
    private int tier = 1;
    private Faction allied_faction;
    private int faction_standing;
    private List<ResourceLocation> metTierProgressions;
    private HashMap<Faction, Double> raidChances;
    private boolean dirty;
    private String lastCodexEntry = "";
    private String lastCodexRecipeType = "";
    private ResourceLocation[] lastCodexRecipeLocations = new ResourceLocation[0];
    private HashMap<Faction, FactionDifficultyStats> factionDifficultyStats;

    public PlayerProgression() {
        this.allied_faction = Faction.NONE;
        this.raidChances = new HashMap();
        this.factionDifficultyStats = new HashMap();
        this.metTierProgressions = new ArrayList<ResourceLocation>();
        this.setDirty();
    }

    @Override
    public int getTier() {
        return this.tier;
    }

    @Override
    public void setTier(int tier, @Nullable PlayerEntity player) {
        if (this.tier == tier) {
            return;
        }
        this.tier = MathUtils.clamp(tier, 1, 5);
        this.metTierProgressions.clear();
        if (player != null) {
            ProgressionEventHandler.confirmExistingAdvancements(player);
        }
        this.setDirty();
    }

    @Override
    public Faction getAlliedFaction() {
        return this.allied_faction;
    }

    @Override
    public boolean hasAlliedFaction() {
        return this.allied_faction != Faction.NONE;
    }

    @Override
    public void setAlliedFaction(Faction faction, @Nullable PlayerEntity player) {
        this.allied_faction = faction;
        if (player != null) {
            player.getCapability(PlayerMagicProvider.MAGIC).ifPresent(magic -> magic.setCastingResourceType(faction.getCastingResource()));
        }
        this.setDirty();
    }

    @Override
    public int getFactionStanding() {
        return this.faction_standing;
    }

    @Override
    public void setFactionStanding(int standing) {
        this.faction_standing = standing;
        this.setDirty();
    }

    @Override
    public void increaseFactionStanding(int amount) {
        this.faction_standing += amount;
        this.setDirty();
    }

    @Override
    public boolean needsSync() {
        return this.dirty;
    }

    @Override
    public void clearSyncFlag() {
        this.dirty = false;
    }

    @Override
    public void addTierProgressionComplete(ResourceLocation complededCondition) {
        if (!this.metTierProgressions.contains(complededCondition)) {
            this.metTierProgressions.add(complededCondition);
            this.setDirty();
        }
    }

    @Override
    public float getTierProgress() {
        return MathUtils.clamp01((float)this.metTierProgressions.size() / (float)ProgressionHelper.getCompletePerTier(this.getTier()));
    }

    @Override
    public List<ResourceLocation> getCompletedProgressionSteps() {
        return this.metTierProgressions;
    }

    @Override
    public void setTierProgression(List<ResourceLocation> complededCondition) {
        this.metTierProgressions.clear();
        this.metTierProgressions.addAll(complededCondition);
        this.setDirty();
    }

    @Override
    public void setDirty() {
        this.dirty = true;
    }

    @Override
    public double getRaidChance(Faction faction) {
        return this.raidChances.getOrDefault((Object)faction, 0.0);
    }

    @Override
    public void setRaidChance(Faction faction, double chance) {
        this.raidChances.put(faction, chance);
    }

    @Override
    public int getRelativeRaidStrength(Faction faction, PlayerEntity player) {
        int strength = 0;
        IPlayerMagic magic = (IPlayerMagic)player.getCapability(PlayerMagicProvider.MAGIC).orElse(null);
        if (magic != null) {
            strength = (int)((double)magic.getMagicLevel() * 1.5);
        }
        return strength *= this.tier;
    }

    @Override
    public boolean canBeRaided(PlayerEntity player) {
        return !player.func_184812_l_() && this.getAlliedFaction() != Faction.NONE && Arrays.asList(Faction.values()).stream().anyMatch(f -> this.canBeRaided((Faction)((Object)f), player));
    }

    @Override
    public boolean canBeRaided(Faction faction, PlayerEntity player) {
        return this.raidChances.getOrDefault((Object)faction, 0.0) >= 1.0;
    }

    @Override
    public void incrementFactionAggro(Faction faction, float min, float max) {
        double chance = this.raidChances.getOrDefault((Object)faction, 0.0) + ((double)min + Math.random() * (double)(max - min));
        this.raidChances.put(faction, chance);
    }

    @Override
    public String getLastCodexEntry() {
        return this.lastCodexEntry;
    }

    @Override
    public void setLastCodexEntry(String key) {
        this.lastCodexEntry = key;
    }

    @Override
    public AbstractMap.SimpleEntry<String, ResourceLocation[]> getLastCodexRecipe() {
        return new AbstractMap.SimpleEntry<String, ResourceLocation[]>(this.lastCodexRecipeType, this.lastCodexRecipeLocations);
    }

    @Override
    public void setLastCodexRecipe(String recipe, ResourceLocation[] rLocs) {
        this.lastCodexRecipeType = recipe;
        this.lastCodexRecipeLocations = rLocs;
    }

    @Override
    public int getTierMaxComplexity() {
        if (this.getTier() == 5) {
            return 999999;
        }
        return 20 * this.getTier();
    }

    @Override
    public FactionDifficultyStats getFactionDifficultyStats(Faction faction) {
        if (!this.factionDifficultyStats.containsKey((Object)faction)) {
            this.factionDifficultyStats.put(faction, new FactionDifficultyStats());
        }
        return this.factionDifficultyStats.get((Object)faction);
    }

    @Override
    public void tickClassicRaids(PlayerEntity player) {
        if (!((Boolean)GeneralModConfig.CLASSIC_RAIDS.get()).booleanValue() || this.getAlliedFaction() == Faction.NONE || this.getTier() < 3) {
            return;
        }
        if (player.field_70170_p.func_82737_E() % 12000L == 0L) {
            double base_increase = (Double)GeneralModConfig.RAID_CHANCE_BASE.get();
            double tier_increase = (Double)GeneralModConfig.RAID_CHANCE_TIER.get() * (double)(this.getTier() - 3);
            Faction anger = Faction.values()[(int)Math.random() * Faction.values().length];
            if (anger == Faction.NONE || anger == this.getAlliedFaction()) {
                return;
            }
            float aggro_amount = (float)(base_increase + tier_increase);
            this.incrementFactionAggro(anger, aggro_amount, aggro_amount);
        }
    }
}

