/*
 * Decompiled with CFR 0.152.
 */
package com.ma.blocks.tileentities.renderers;

import com.google.common.collect.ImmutableList;
import com.ma.ManaAndArtifice;
import com.ma.blocks.tileentities.EldrinConduitTile;
import com.ma.tools.RLoc;
import com.ma.tools.render.ModelUtils;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.List;
import java.util.Random;
import java.util.stream.IntStream;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.dispenser.IPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.World;

public class EldrinConduitRenderer
extends TileEntityRenderer<EldrinConduitTile> {
    private final ResourceLocation inner = RLoc.create("block/eldrin/supplier_lower_interior");
    private final ResourceLocation frame = RLoc.create("block/eldrin/supplier_lower_exterior");
    private final ResourceLocation crystal = RLoc.create("block/eldrin/supplier_upper");
    private static final List<RenderType> RENDER_TYPES = (List)IntStream.range(0, 16).mapToObj(p_228882_0_ -> RenderType.func_228630_a_((int)(p_228882_0_ + 1))).collect(ImmutableList.toImmutableList());
    private static final Random RANDOM = new Random(31100L);

    public EldrinConduitRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(EldrinConduitTile tileEntityIn, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        World world = tileEntityIn.func_145831_w();
        BlockPos pos = tileEntityIn.func_174877_v();
        BlockState state = tileEntityIn.func_195044_w();
        double d0 = tileEntityIn.func_174877_v().func_218138_a((IPosition)this.field_228858_b_.field_217666_g.func_216785_c(), true);
        int i = this.getPasses(d0);
        float partialTick = (float)ManaAndArtifice.instance.proxy.getGameTicks() + partialTicks;
        float radians = (float)((double)partialTick * Math.PI / 180.0);
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.5, 0.75, 0.5);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229193_c_(radians));
        float scale = 0.6f;
        matrixStack.func_227862_a_(scale, scale, scale);
        float colorMod = 0.15f;
        this.renderModelWithRandomColor(matrixStack, bufferIn.getBuffer(RENDER_TYPES.get(0)), world, pos, state, colorMod, combinedLightIn, combinedOverlayIn);
        for (int j = 1; j < i; ++j) {
            colorMod = 2.0f / (float)(18 - j);
            this.renderModelWithRandomColor(matrixStack, bufferIn.getBuffer(RENDER_TYPES.get(j)), world, pos, state, colorMod, combinedLightIn, combinedOverlayIn);
        }
        ModelUtils.renderModel(bufferIn, world, pos, state, this.frame, matrixStack, combinedLightIn, combinedOverlayIn);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229193_c_(-radians * 2.0f));
        ModelUtils.renderModel(bufferIn, world, pos, state, this.crystal, matrixStack, combinedLightIn, combinedOverlayIn);
        matrixStack.func_227865_b_();
    }

    private void renderModelWithRandomColor(MatrixStack stack, IVertexBuilder builder, World world, BlockPos pos, BlockState state, float colorMod, int light, int overlay) {
        float r = (RANDOM.nextFloat() * 0.5f + 0.1f) * colorMod;
        float g = (RANDOM.nextFloat() * 0.5f + 0.4f) * colorMod;
        float b = (RANDOM.nextFloat() * 0.5f + 0.5f) * colorMod;
        ModelUtils.renderModel(builder, world, pos, state, this.inner, stack, new float[]{1.0f, r, g, b}, light, overlay);
    }

    protected int getPasses(double dist) {
        if (dist > 36864.0) {
            return 1;
        }
        if (dist > 25600.0) {
            return 3;
        }
        if (dist > 16384.0) {
            return 5;
        }
        if (dist > 9216.0) {
            return 7;
        }
        if (dist > 4096.0) {
            return 9;
        }
        if (dist > 1024.0) {
            return 11;
        }
        if (dist > 576.0) {
            return 13;
        }
        return dist > 256.0 ? 14 : 15;
    }
}

