/*
 * Decompiled with CFR 0.152.
 */
package com.ma.blocks.tileentities.renderers;

import com.ma.ManaAndArtifice;
import com.ma.blocks.tileentities.EldrinAltarTile;
import com.ma.tools.RLoc;
import com.ma.tools.math.MathUtils;
import com.ma.tools.render.MARenderTypes;
import com.ma.tools.render.ModelUtils;
import com.ma.tools.render.WorldRenderUtils;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;

public class EldrinAltarRenderer
extends TileEntityRenderer<EldrinAltarTile> {
    private final ResourceLocation crystal = RLoc.create("block/eldrin/receiver_crystal");
    private final ItemRenderer itemRenderer = Minecraft.func_71410_x().func_175599_af();
    private static final Vector3d CrystalOffset = new Vector3d(0.5, 1.1, 0.5);
    private static final Vector3d TileBeamOffset = new Vector3d(0.0, 0.93, 0.0);

    public EldrinAltarRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(EldrinAltarTile tileEntityIn, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        ItemStack itemstack = tileEntityIn.getDisplayedItem();
        World world = tileEntityIn.func_145831_w();
        BlockPos pos = tileEntityIn.func_174877_v();
        BlockState state = tileEntityIn.func_195044_w();
        if (!itemstack.func_190926_b()) {
            this.renderItem(matrixStackIn, itemstack, combinedLightIn, bufferIn);
        }
        float partialTick = (float)ManaAndArtifice.instance.proxy.getGameTicks() + partialTicks;
        Vector3d center = Vector3d.func_237491_b_((Vector3i)pos);
        this.renderFloatingCrystals(tileEntityIn, partialTick, partialTicks, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn, world, pos, state, center);
        this.renderCollectedItems(tileEntityIn, partialTick, matrixStackIn, bufferIn, combinedLightIn, center);
    }

    private void renderFloatingCrystals(EldrinAltarTile tileEntityIn, float partialTick, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn, World world, BlockPos pos, BlockState state, Vector3d center) {
        Vector3d[] offsets = EldrinAltarTile.crystal_offsets;
        double[] yOffsets = new double[offsets.length];
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227861_a_(0.5, 0.0, 0.5);
        for (int i = 0; i < offsets.length; ++i) {
            yOffsets[i] = Math.sin((double)(partialTick + (float)(i * 20)) * Math.PI / 180.0) / 15.0;
            matrixStackIn.func_227860_a_();
            matrixStackIn.func_227861_a_(offsets[i].func_82615_a(), 1.0 + offsets[i].func_82617_b() + yOffsets[i], offsets[i].func_82616_c());
            ModelUtils.renderModel(bufferIn, world, pos, state, this.crystal, matrixStackIn, combinedLightIn, combinedOverlayIn);
            matrixStackIn.func_227865_b_();
        }
        matrixStackIn.func_227865_b_();
        int ticksForEachBeam = 5;
        int stageTicks = tileEntityIn.getStageTicks();
        for (int i = 0; i < tileEntityIn.getActiveCrystals().size(); ++i) {
            if (tileEntityIn.getStage() == EldrinAltarTile.Stage.CONSUMING_REAGENTS && tileEntityIn.getStageTicks() < i * ticksForEachBeam) continue;
            EldrinAltarTile.ActiveCrystal e = tileEntityIn.getActiveCrystals().get(i);
            Vector3d crystalPos = CrystalOffset.func_178787_e(offsets[e.offsetIndex]).func_72441_c(0.0, yOffsets[e.offsetIndex], 0.0);
            Vector3d tilePos = Vector3d.func_237489_a_((Vector3i)e.tilePos).func_178788_d(center).func_178787_e(TileBeamOffset);
            float minStageTicks = ticksForEachBeam * i;
            float maxStageTicks = minStageTicks + (float)ticksForEachBeam;
            float beamPct = 1.0f;
            if (tileEntityIn.getStage() == EldrinAltarTile.Stage.CONSUMING_REAGENTS) {
                if ((float)stageTicks < minStageTicks) continue;
                beamPct = MathUtils.clamp01(((float)stageTicks + partialTicks) / maxStageTicks);
            }
            if (!(beamPct > 0.0f)) continue;
            matrixStackIn.func_227860_a_();
            matrixStackIn.func_227861_a_(tilePos.field_72450_a, tilePos.field_72448_b, tilePos.field_72449_c);
            WorldRenderUtils.renderBeam(world, partialTicks, matrixStackIn, bufferIn, combinedLightIn, tilePos, crystalPos, beamPct, e.affinity.getShiftAffinity().getColor(), 0.05f, MARenderTypes.RITUAL_BEAM_RENDER_TYPE);
            matrixStackIn.func_227865_b_();
        }
        if (tileEntityIn.getStage() == EldrinAltarTile.Stage.COMPLETING && tileEntityIn.getStageTicks() > 80) {
            float stagePlusPartial = (float)tileEntityIn.getStageTicks() + partialTicks;
            float pct = MathUtils.clamp01((stagePlusPartial - 80.0f) / 20.0f);
            int alpha = (int)(176.0f * pct);
            float scale = 0.01f + 2.74f * pct;
            Vector3d relativeCenterPos = new Vector3d(0.5, 1.5, 0.5);
            for (int i = 0; i < tileEntityIn.getActiveCrystals().size(); ++i) {
                EldrinAltarTile.ActiveCrystal e = tileEntityIn.getActiveCrystals().get(i);
                Vector3d crystalPos = CrystalOffset.func_178787_e(offsets[e.offsetIndex]).func_72441_c(0.0, yOffsets[e.offsetIndex], 0.0);
                matrixStackIn.func_227860_a_();
                matrixStackIn.func_227861_a_(crystalPos.field_72450_a, crystalPos.field_72448_b, crystalPos.field_72449_c);
                WorldRenderUtils.renderBeam(world, partialTicks, matrixStackIn, bufferIn, combinedLightIn, crystalPos, relativeCenterPos, pct, e.affinity.getShiftAffinity().getColor(), 0.05f, MARenderTypes.RITUAL_BEAM_RENDER_TYPE);
                matrixStackIn.func_227865_b_();
            }
            int[] innerColor = new int[]{7, 43, 155};
            int[] outerColor = new int[]{20, 40, 150};
            matrixStackIn.func_227860_a_();
            matrixStackIn.func_227861_a_(relativeCenterPos.field_72450_a, relativeCenterPos.field_72448_b, relativeCenterPos.field_72449_c);
            WorldRenderUtils.renderRadiant(stageTicks, matrixStackIn, bufferIn, innerColor, outerColor, alpha, scale, false);
            matrixStackIn.func_227865_b_();
        }
    }

    private void renderCollectedItems(EldrinAltarTile tileEntityIn, float partialTick, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, Vector3d center) {
        if (tileEntityIn.getStage() != EldrinAltarTile.Stage.CONSUMING_REAGENTS) {
            return;
        }
        float rotation = (float)tileEntityIn.getStageTicks() + partialTick;
        int maxItems = tileEntityIn.getCollectedItems().size() - tileEntityIn.getStageTicks() / 20;
        float yOffset = 0.53f + 0.43f * MathUtils.clamp01((float)tileEntityIn.getStageTicks() / 10.0f);
        for (int i = 0; i < maxItems; ++i) {
            EldrinAltarTile.CollectedItem item = tileEntityIn.getCollectedItems().get(i);
            Vector3d tilePos = Vector3d.func_237489_a_((Vector3i)item.tilePos).func_178788_d(center).func_72441_c(0.0, (double)yOffset, 0.0);
            matrixStackIn.func_227860_a_();
            matrixStackIn.func_227861_a_(tilePos.field_72450_a, tilePos.field_72448_b, tilePos.field_72449_c);
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(i % 4 == 0 ? -rotation : rotation));
            matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(i % 2 == 0 ? rotation : -rotation));
            matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(i % 3 == 0 ? -rotation : rotation));
            matrixStackIn.func_227862_a_(0.5f, 0.5f, 0.5f);
            this.itemRenderer.func_229110_a_(item.stack, ItemCameraTransforms.TransformType.FIXED, combinedLightIn, OverlayTexture.field_229196_a_, matrixStackIn, bufferIn);
            matrixStackIn.func_227865_b_();
        }
    }

    private void renderItem(MatrixStack matrixStackIn, ItemStack itemstack, int combinedLightIn, IRenderTypeBuffer bufferIn) {
        matrixStackIn.func_227860_a_();
        if (itemstack.func_77973_b() instanceof BlockItem) {
            matrixStackIn.func_227861_a_(0.5, 1.05, 0.5);
        } else {
            matrixStackIn.func_227861_a_(0.5, 1.0, 0.5);
            matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
        }
        matrixStackIn.func_227862_a_(0.5f, 0.5f, 0.5f);
        this.itemRenderer.func_229110_a_(itemstack, ItemCameraTransforms.TransformType.FIXED, combinedLightIn, OverlayTexture.field_229196_a_, matrixStackIn, bufferIn);
        matrixStackIn.func_227865_b_();
    }
}

