/*
 * Decompiled with CFR 0.152.
 */
package com.ma.blocks.tileentities;

import com.ma.api.affinity.Affinity;
import com.ma.api.blocks.tile.MultiblockTile;
import com.ma.api.capabilities.Faction;
import com.ma.api.capabilities.WellspringNode;
import com.ma.blocks.artifice.RefractionLensBlock;
import com.ma.blocks.tileentities.init.TileEntityInit;
import com.ma.capabilities.playerdata.progression.PlayerProgressionProvider;
import com.ma.capabilities.worlddata.WorldMagicProvider;
import com.ma.network.ClientMessageDispatcher;
import com.ma.tools.RLoc;
import com.ma.tools.render.MultiblockRenderer;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class RefractionLensTile
extends MultiblockTile
implements ITickableTileEntity {
    private Affinity affinity;
    private UUID placedBy;
    private Faction placedByFaction;
    private boolean initialRequest = false;

    public RefractionLensTile(TileEntityType<?> type, Affinity aff) {
        super(type, RLoc.create("multiblock/wellspring_capture"));
        this.affinity = aff;
        this.placedBy = null;
        this.placedByFaction = Faction.NONE;
    }

    public RefractionLensTile(TileEntityType<?> type) {
        this(type, Affinity.UNKNOWN);
    }

    public RefractionLensTile() {
        this((TileEntityType)TileEntityInit.REFRACTION_LENS.get());
    }

    public RefractionLensTile(Affinity affinity) {
        this((TileEntityType)TileEntityInit.REFRACTION_LENS.get(), affinity);
    }

    @Override
    public void func_73660_a() {
        boolean wasValid = this.structureMatched;
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            this.spawnParticles();
            if (!this.initialRequest) {
                this.initialRequest = true;
                ClientMessageDispatcher.sendRequestWellspringNetworkSyncMessage(true);
            }
        } else if (wasValid && !this.structureMatched) {
            this.removePowerFromNetwork();
        } else if (!wasValid && this.structureMatched) {
            this.addPowerToNetwork();
        }
    }

    public void func_145843_s() {
        if (!this.field_145850_b.field_72995_K) {
            this.removePowerFromNetwork();
        }
        super.func_145843_s();
    }

    @OnlyIn(value=Dist.CLIENT)
    private void spawnParticles() {
    }

    @Override
    protected BlockPos getMatchOrigin() {
        return this.func_174877_v().func_177979_c(4);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        nbt.func_74778_a("affinity", this.affinity.name());
        if (this.placedBy != null) {
            nbt.func_74778_a("placedBy", this.placedBy.toString());
        }
        nbt.func_74778_a("placedByFaction", this.placedByFaction.name());
        return super.func_189515_b(nbt);
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        if (nbt.func_74764_b("affinity")) {
            this.affinity = Affinity.valueOf(nbt.func_74779_i("affinity"));
        }
        if (nbt.func_74764_b("placedByFaction")) {
            this.placedByFaction = Faction.valueOf(nbt.func_74779_i("placedByFaction"));
        }
        if (nbt.func_74764_b("placedBy")) {
            this.placedBy = UUID.fromString(nbt.func_74779_i("placedBy"));
        }
        super.func_230337_a_(state, nbt);
    }

    private void addPowerToNetwork() {
        if (this.placedBy == null || this.placedByFaction == Faction.NONE || !(this.field_145850_b instanceof ServerWorld)) {
            return;
        }
        this.field_145850_b.getCapability(WorldMagicProvider.MAGIC).ifPresent(m -> {
            Optional<WellspringNode> entry = m.getWellspringRegistry().getNodeAt(this.func_174877_v());
            entry.ifPresent(n -> {
                if (n.getAffinity().getShiftAffinity() == this.affinity || n.getAffinity() == Affinity.UNKNOWN) {
                    if (!m.getWellspringRegistry().claimNode((ServerWorld)this.field_145850_b, this.placedBy, this.placedByFaction, this.func_174877_v(), this.affinity)) {
                        this.field_145850_b.func_175656_a(this.func_174877_v(), (BlockState)this.func_195044_w().func_206870_a((Property)RefractionLensBlock.INVALID, (Comparable)Boolean.valueOf(true)));
                    } else {
                        this.field_145850_b.func_175656_a(this.func_174877_v(), (BlockState)this.func_195044_w().func_206870_a((Property)RefractionLensBlock.INVALID, (Comparable)Boolean.valueOf(false)));
                    }
                } else {
                    this.field_145850_b.func_175656_a(this.func_174877_v(), (BlockState)this.func_195044_w().func_206870_a((Property)RefractionLensBlock.INVALID, (Comparable)Boolean.valueOf(true)));
                }
            });
            if (!entry.isPresent()) {
                this.field_145850_b.func_175656_a(this.func_174877_v(), (BlockState)this.func_195044_w().func_206870_a((Property)RefractionLensBlock.INVALID, (Comparable)Boolean.valueOf(true)));
            }
        });
    }

    private void removePowerFromNetwork() {
        this.field_145850_b.getCapability(WorldMagicProvider.MAGIC).ifPresent(m -> m.getWellspringRegistry().unclaimNode((ServerWorld)this.field_145850_b, this.func_174877_v()));
    }

    public void setPlacedBy(PlayerEntity player) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.placedBy = player.func_110124_au();
        player.getCapability(PlayerProgressionProvider.PROGRESSION).ifPresent(p -> {
            this.placedByFaction = p.getAlliedFaction();
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setGhostMultiblock() {
        this.getDefinition().ifPresent(r -> {
            BlockPos anchorPos = this.getMatchOrigin();
            MultiblockRenderer.setMultiblock(r, (ITextComponent)new TranslationTextComponent(r.func_199560_c().toString()), false);
            MultiblockRenderer.anchorTo(anchorPos, Rotation.NONE);
        });
    }
}

