/*
 * Decompiled with CFR 0.152.
 */
package com.ma.blocks.tileentities;

import com.ma.Registries;
import com.ma.api.blocks.tile.TileEntityWithInventory;
import com.ma.api.capabilities.IPlayerProgression;
import com.ma.api.spells.adjusters.SpellCastStage;
import com.ma.api.spells.attributes.Attribute;
import com.ma.api.spells.parts.Component;
import com.ma.api.spells.parts.Modifier;
import com.ma.api.spells.parts.Shape;
import com.ma.blocks.BlockInit;
import com.ma.blocks.sorcery.InscriptionTableBlock;
import com.ma.blocks.tileentities.init.TileEntityInit;
import com.ma.gui.containers.block.ContainerInscriptionTable;
import com.ma.items.ItemInit;
import com.ma.network.ClientMessageDispatcher;
import com.ma.network.ServerMessageDispatcher;
import com.ma.network.messages.to_server.InscriptionTableAttributeChangeMessage;
import com.ma.network.messages.to_server.InscriptionTableCraftingUpdateMessage;
import com.ma.network.messages.to_server.InscriptionTableRequestStartCraftingMessage;
import com.ma.network.messages.to_server.InscriptionTableSetComponentMessage;
import com.ma.network.messages.to_server.InscriptionTableSetModifierMessage;
import com.ma.network.messages.to_server.InscriptionTableSetShapeMessage;
import com.ma.spells.SpellCaster;
import com.ma.spells.crafting.ModifiedSpellPart;
import com.ma.spells.crafting.SpellRecipe;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.CustomInstructionKeyframeEvent;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class InscriptionTableTile
extends TileEntityWithInventory
implements INamedContainerProvider,
Consumer<PacketBuffer>,
ITickableTileEntity,
IAnimatable,
AnimationController.ICustomInstructionListener {
    private static final int SIZE_INVENTORY = 4;
    private static final int SLOT_INK = 0;
    private static final int SLOT_PAPER = 1;
    private static final int SLOT_FUEL = 2;
    private static final int SLOT_OUTPUT = 3;
    private static final int TICKS_PER_FUEL = 160;
    private static final int SCRIBE_TICKS_PER_COMPLEXITY = 20;
    private SpellRecipe recipe = new SpellRecipe();
    private boolean isCrafting = false;
    private int craftTicksTotal = 0;
    private int craftTicksConsumed = 0;
    private int burnTicksRemaining = 0;
    private int inkDamageRemaining = 0;
    private int paperRemaining = 0;
    private int fuelRemaining = 0;
    private UUID tableuuid;
    private boolean creative;
    private AnimationFactory animFactory = new AnimationFactory((IAnimatable)this);

    public InscriptionTableTile(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn, 4);
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.isCrafting) {
            if (!this.creative) {
                if (this.paperRemaining > 0 || this.inkDamageRemaining > 0) {
                    this.consumeMaterials();
                    return;
                }
                if (this.burnTicksRemaining <= 5) {
                    if (!this.field_145850_b.field_72995_K) {
                        this.tryConsumeFuel();
                    }
                    return;
                }
            }
            ++this.craftTicksConsumed;
            --this.burnTicksRemaining;
            if (!this.field_145850_b.field_72995_K) {
                if (this.craftTicksConsumed >= this.craftTicksTotal) {
                    this.completeSpellPart();
                } else if (this.craftTicksConsumed > 0 && this.craftTicksConsumed % 20 == 0) {
                    ServerMessageDispatcher.sendInscriptionTableCraftingUpdate(this);
                }
            }
        }
    }

    public void setCreative(boolean creative) {
        this.creative = creative;
    }

    public boolean isCraftingPaused() {
        return this.isCrafting && (this.paperRemaining > 0 || this.inkDamageRemaining > 0);
    }

    private void completeSpellPart() {
        this.isCrafting = false;
        this.burnTicksRemaining = 0;
        this.craftTicksConsumed = 0;
        this.craftTicksTotal = 0;
        ItemStack outputStack = this.creative ? new ItemStack((IItemProvider)ItemInit.SPELL.get()) : new ItemStack((IItemProvider)ItemInit.ENCHANTED_VELLUM.get());
        this.recipe.setMysterious(false);
        this.recipe.writeToNBT(outputStack.func_196082_o());
        this.recipe.writeRecipeForRitual(this.field_145850_b, outputStack.func_196082_o());
        this.func_70299_a(3, outputStack);
        ServerMessageDispatcher.sendInscriptionTableCraftingUpdate(this);
        this.field_145850_b.func_175666_e(this.field_174879_c, this.func_195044_w().func_177230_c());
    }

    private void tryConsumeFuel() {
        ItemStack consumeStack = this.func_70298_a(2, 1);
        if (!consumeStack.func_190926_b()) {
            this.burnTicksRemaining = 160;
            ServerMessageDispatcher.sendInscriptionTableCraftingUpdate(this);
        }
    }

    public CraftCheckResult canBeginCrafting(IPlayerProgression progression) {
        if (this.isCrafting) {
            return CraftCheckResult.ALREADY_CRAFTING;
        }
        if (!this.func_70301_a(3).func_190926_b()) {
            return CraftCheckResult.OUTPUT_FULL;
        }
        if (this.getCurrentShape() == null) {
            return CraftCheckResult.NO_SHAPE;
        }
        if (this.getCurrentComponent() == null) {
            return CraftCheckResult.NO_COMPONENT;
        }
        if (this.getCurrentShape().getPart().isChanneled() && !this.getCurrentComponent().getPart().canBeChanneled()) {
            return CraftCheckResult.CANNOT_CHANNEL;
        }
        if (this.creative) {
            return CraftCheckResult.READY;
        }
        if (progression.getTier() < this.getCurrentRecipe().getTier(this.field_145850_b)) {
            return CraftCheckResult.LOW_TIER;
        }
        if (this.getCurrentRecipe().getComplexity() > (float)progression.getTierMaxComplexity()) {
            return CraftCheckResult.TOO_COMPLEX;
        }
        if (!this.getCurrentRecipe().canFactionCraft(progression)) {
            return CraftCheckResult.WRONG_FACTION;
        }
        this.calculateMaterialRequirements();
        if (this.func_70301_a(1).func_190916_E() < this.paperRemaining) {
            return CraftCheckResult.MISSING_VELLUM;
        }
        if (this.func_70301_a(0).func_77958_k() - this.func_70301_a(0).func_77952_i() < this.inkDamageRemaining) {
            return CraftCheckResult.MISSING_INK;
        }
        if (this.func_70301_a(2).func_190916_E() == 0) {
            return CraftCheckResult.MISSING_ASH;
        }
        return CraftCheckResult.READY;
    }

    private void consumeMaterials() {
        int availableInk;
        ItemStack ink;
        boolean updated = false;
        ItemStack paperconsumed = this.func_70298_a(1, this.paperRemaining);
        if (!paperconsumed.func_190926_b()) {
            this.paperRemaining -= paperconsumed.func_190916_E();
            updated = true;
        }
        if (!(ink = this.func_70301_a(0)).func_190926_b() && (availableInk = this.func_70301_a(0).func_77958_k() - this.func_70301_a(0).func_77952_i()) > 0) {
            if (availableInk > this.inkDamageRemaining) {
                this.func_70301_a(0).func_196085_b(this.func_70301_a(0).func_77952_i() + this.inkDamageRemaining);
                this.inkDamageRemaining = 0;
            } else {
                this.inkDamageRemaining -= availableInk;
                this.func_70301_a(0).func_196085_b(this.func_70301_a(0).func_77958_k());
            }
            updated = true;
        }
        if (updated) {
            ServerMessageDispatcher.sendInscriptionTableCraftingUpdate(this);
        }
    }

    private void calculateMaterialRequirements() {
        this.paperRemaining = (int)Math.ceil(this.getComplexity() / 5.0f);
        this.inkDamageRemaining = (int)Math.ceil(this.getComplexity() / 2.5f);
        this.fuelRemaining = (int)Math.ceil((float)((int)this.getComplexity() * 20) / 160.0f);
    }

    public InscriptionTableTile() {
        this((TileEntityType)TileEntityInit.INSCRIPTION_TABLE.get());
    }

    public Container createMenu(int id, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerInscriptionTable(id, playerInventory, this);
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("mana-and-artifice:container.inscription_table");
    }

    public void setCurrentShape(Shape shape) {
        if (this.isCrafting) {
            return;
        }
        this.recipe.setShape(shape);
        if (this.func_145830_o()) {
            if (!this.field_145850_b.field_72995_K) {
                this.func_70296_d();
            } else {
                ClientMessageDispatcher.sendInscriptionTableSetShape(this);
            }
        }
        this.calculateMaterialRequirements();
    }

    public void setCurrentComponent(Component component) {
        if (this.isCrafting) {
            return;
        }
        this.recipe.clearComponents();
        if (component != null) {
            this.recipe.addComponent(component);
        }
        if (this.func_145830_o()) {
            if (!this.field_145850_b.field_72995_K) {
                this.func_70296_d();
            } else {
                ClientMessageDispatcher.sendInscriptionTableSetComponent(this);
            }
        }
        this.calculateMaterialRequirements();
    }

    public void setCurrentModifier(Modifier modifier, int index) {
        if (this.isCrafting) {
            return;
        }
        this.recipe.setModifier(modifier, index);
        if (this.func_145830_o()) {
            if (this.field_145850_b.field_72995_K) {
                ClientMessageDispatcher.sendInscriptionTableSetModifier(this, modifier != null ? modifier.getRegistryName() : new ResourceLocation(""), index);
            } else {
                this.func_70296_d();
            }
        }
        this.calculateMaterialRequirements();
    }

    public SpellRecipe getCurrentRecipe() {
        return this.recipe;
    }

    public ModifiedSpellPart<Shape> getCurrentShape() {
        return this.recipe.getShape();
    }

    public ModifiedSpellPart<Component> getCurrentComponent() {
        return this.recipe.getComponent(0);
    }

    public Modifier getCurrentModifier(int index) {
        return this.recipe.getModifier(index);
    }

    public void build() {
        if (this.recipe.isValid() && this.func_70301_a(3).func_190926_b()) {
            if (this.field_145850_b.field_72995_K) {
                ClientMessageDispatcher.sendInscriptionTableRequestStartCrafting(this);
            } else {
                this.isCrafting = true;
                this.craftTicksTotal = this.creative ? 5 : (int)this.getComplexity() * 20;
                this.craftTicksConsumed = 0;
                if (this.func_145830_o() && !this.field_145850_b.field_72995_K) {
                    this.calculateMaterialRequirements();
                    ServerMessageDispatcher.sendInscriptionTableCraftingUpdate(this);
                    this.func_70296_d();
                    this.field_145850_b.func_175666_e(this.field_174879_c, this.func_195044_w().func_177230_c());
                }
            }
        }
    }

    public boolean isBuilding() {
        return this.isCrafting;
    }

    public void changeShapeAttributeValue(Attribute attribute, float newValue) {
        if (this.recipe.changeShapeAttributeValue(attribute, newValue) && this.func_145830_o()) {
            if (this.field_145850_b.field_72995_K) {
                ClientMessageDispatcher.sendInscriptionTableAttributeChange(this, attribute, newValue, InscriptionTableAttributeChangeMessage.ChangeType.SHAPE);
            } else {
                this.func_70296_d();
            }
        }
        this.calculateMaterialRequirements();
    }

    public void changeComponentAttributeValue(Attribute attribute, float newValue) {
        if (this.recipe.changeComponentAttributeValue(0, attribute, newValue) && this.func_145830_o()) {
            if (this.field_145850_b.field_72995_K) {
                ClientMessageDispatcher.sendInscriptionTableAttributeChange(this, attribute, newValue, InscriptionTableAttributeChangeMessage.ChangeType.COMPONENT);
            } else {
                this.func_70296_d();
            }
        }
        this.calculateMaterialRequirements();
    }

    public float getComplexity() {
        return this.recipe.getComplexity();
    }

    public float getManaCost(PlayerEntity player) {
        this.recipe.calculateManaCost();
        SpellCaster.applyAdjusters(ItemStack.field_190927_a, player, this.recipe, SpellCastStage.SPELLCRAFTING_MANA_COST_ESTIMATE);
        return this.recipe.isChanneled() ? this.recipe.getManaCost() * 20.0f : this.recipe.getManaCost();
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        CompoundNBT recipeData = new CompoundNBT();
        this.recipe.writeToNBT(recipeData);
        compound.func_218657_a("recipe_data", (INBT)recipeData);
        compound.func_74757_a("isCrafting", this.isCrafting);
        compound.func_74768_a("craftTicksTotal", this.craftTicksTotal);
        compound.func_74768_a("craftTicksConsumed", this.craftTicksConsumed);
        compound.func_74768_a("burnTicksRemaining", this.burnTicksRemaining);
        compound.func_74768_a("inkDamageRemaining", this.inkDamageRemaining);
        compound.func_74768_a("paperRemaining", this.paperRemaining);
        return super.func_189515_b(compound);
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        if (compound.func_74764_b("recipe_data")) {
            this.recipe = SpellRecipe.fromNBT(compound.func_74775_l("recipe_data"));
        }
        compound.func_74767_n("isCrafting");
        this.craftTicksTotal = compound.func_74762_e("craftTicksTotal");
        this.craftTicksConsumed = compound.func_74762_e("craftTicksConsumed");
        this.burnTicksRemaining = compound.func_74762_e("burnTicksRemaining");
        this.inkDamageRemaining = compound.func_74762_e("inkDamageRemaining");
        this.paperRemaining = compound.func_74762_e("paperRemaining");
        super.func_230337_a_(state, compound);
    }

    @Override
    public void accept(PacketBuffer data) {
        data.func_179255_a(this.func_174877_v());
        CompoundNBT nbt = new CompoundNBT();
        this.recipe.writeToNBT(nbt);
        data.func_150786_a(nbt);
        data.writeInt(this.craftTicksTotal);
        data.writeInt(this.craftTicksConsumed);
        data.writeInt(this.burnTicksRemaining);
        data.writeInt(this.inkDamageRemaining);
        data.writeInt(this.paperRemaining);
    }

    public InscriptionTableTile readFrom(PacketBuffer data) {
        this.recipe = SpellRecipe.fromNBT(data.func_150793_b());
        this.craftTicksTotal = data.readInt();
        this.craftTicksConsumed = data.readInt();
        this.burnTicksRemaining = data.readInt();
        this.inkDamageRemaining = data.readInt();
        this.paperRemaining = data.readInt();
        return this;
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.func_174877_v(), 0, this.func_189515_b(new CompoundNBT()));
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(this.func_195044_w(), pkt.func_148857_g());
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT base = super.func_189517_E_();
        base.func_218657_a("data", (INBT)this.func_189515_b(new CompoundNBT()));
        return base;
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        super.handleUpdateTag(state, tag);
        CompoundNBT sub = tag.func_74775_l("data");
        this.func_230337_a_(state, sub);
    }

    public int getCraftTicks() {
        return this.craftTicksTotal;
    }

    public int getCraftTicksConsumed() {
        return this.craftTicksConsumed;
    }

    public int getBurnTicksRemaining() {
        return this.burnTicksRemaining;
    }

    public int getPaperRemaining() {
        return this.paperRemaining;
    }

    public int getInkRemaining() {
        return this.inkDamageRemaining;
    }

    public int getFuelRemaining() {
        return this.fuelRemaining;
    }

    public NonNullList<ResourceLocation> getReagentsForComplexity() {
        return this.recipe.getReagentsForComplexity();
    }

    public void func_70296_d() {
        super.func_70296_d();
        int modelStateFlag = 0;
        if (!this.func_70301_a(0).func_190926_b()) {
            modelStateFlag |= 1;
        }
        if (!this.func_70301_a(1).func_190926_b()) {
            modelStateFlag |= 2;
        }
        if (!this.func_70301_a(2).func_190926_b()) {
            modelStateFlag |= 4;
        }
        this.field_145850_b.func_175656_a(this.func_174877_v(), (BlockState)this.func_195044_w().func_206870_a((Property)InscriptionTableBlock.CONTAINED_RESOURCES, (Comparable)Integer.valueOf(modelStateFlag)));
    }

    public void registerControllers(AnimationData data) {
        AnimationController controller = new AnimationController((IAnimatable)this, "controller", 5.0f, this::predicate);
        controller.registerCustomInstructionListener((AnimationController.ICustomInstructionListener)this);
        data.addAnimationController(controller);
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        event.getController().transitionLengthTicks = 20.0;
        if (this.isBuilding() && !this.isCraftingPaused()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.inscription_table.quillwrite", Boolean.valueOf(true)));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.inscription_table.quillidle", Boolean.valueOf(false)));
        }
        return PlayState.CONTINUE;
    }

    public AnimationFactory getFactory() {
        return this.animFactory;
    }

    public void executeInstruction(CustomInstructionKeyframeEvent event) {
    }

    private static InscriptionTableTile getAndVerify(World world, BlockPos position) {
        TileEntity te;
        if (world.func_195588_v(position) && world.func_180495_p(position).func_177230_c() == BlockInit.INSCRIPTION_TABLE.get() && (te = world.func_175625_s(position)) != null && te instanceof InscriptionTableTile) {
            return (InscriptionTableTile)te;
        }
        return null;
    }

    public static final void handleShapeSet(ServerPlayerEntity sendingPlayer, InscriptionTableSetShapeMessage message) {
        InscriptionTableTile te = InscriptionTableTile.getAndVerify(sendingPlayer.field_70170_p, message.getPosition());
        if (te == null) {
            return;
        }
        Shape spellShape = (Shape)Registries.Shape.getValue(message.getShape());
        te.setCurrentShape(spellShape);
    }

    public static final void handleComponentSet(ServerPlayerEntity sendingPlayer, InscriptionTableSetComponentMessage message) {
        InscriptionTableTile te = InscriptionTableTile.getAndVerify(sendingPlayer.field_70170_p, message.getPosition());
        if (te == null) {
            return;
        }
        Component spellComponent = (Component)Registries.Component.getValue(message.getComponent());
        te.setCurrentComponent(spellComponent);
    }

    public static final void handleModifierSet(ServerPlayerEntity sendingPlayer, InscriptionTableSetModifierMessage message) {
        if (message.getIndex() < 0 || message.getIndex() >= 3) {
            return;
        }
        InscriptionTableTile te = InscriptionTableTile.getAndVerify(sendingPlayer.field_70170_p, message.getPosition());
        if (te == null) {
            return;
        }
        Modifier spellModifier = (Modifier)Registries.Modifier.getValue(message.getModifier());
        te.setCurrentModifier(spellModifier, message.getIndex());
    }

    public static final void handleAttributeValueChange(ServerPlayerEntity sendingPlayer, InscriptionTableAttributeChangeMessage message) {
        InscriptionTableTile te = InscriptionTableTile.getAndVerify(sendingPlayer.field_70170_p, message.getPosition());
        if (te == null) {
            return;
        }
        switch (message.getChangeType()) {
            case COMPONENT: {
                te.changeComponentAttributeValue(message.getAttribute(), message.getValue());
                break;
            }
            case SHAPE: {
                te.changeShapeAttributeValue(message.getAttribute(), message.getValue());
            }
        }
    }

    public static final void handleRequestStartCrafting(ServerPlayerEntity sendingPlayer, InscriptionTableRequestStartCraftingMessage message) {
        InscriptionTableTile te = InscriptionTableTile.getAndVerify(sendingPlayer.field_70170_p, message.getPosition());
        if (te == null) {
            return;
        }
        if (!te.isBuilding()) {
            te.build();
        }
    }

    public static final void handleCraftingUpdate(World world, InscriptionTableCraftingUpdateMessage message) {
        InscriptionTableTile te = InscriptionTableTile.getAndVerify(world, message.getPosition());
        if (te == null) {
            return;
        }
        te.isCrafting = message.getBurnTimeRemaining() > 0;
        te.craftTicksTotal = message.getTotalCraftTicks();
        te.craftTicksConsumed = message.getCraftTicksPassed();
        te.burnTicksRemaining = message.getBurnTimeRemaining();
        te.inkDamageRemaining = message.getInkRemaining();
        te.paperRemaining = message.getPaperRemaining();
    }

    public static enum CraftCheckResult {
        READY(""),
        NO_SHAPE("gui.mana-and-artifice.inscription.shape_missing"),
        NO_COMPONENT("gui.mana-and-artifice.inscription.component_missing"),
        MISSING_INK("gui.mana-and-artifice.inscription.ink_missing"),
        MISSING_VELLUM("gui.mana-and-artifice.inscription.vellum_missing"),
        MISSING_ASH("gui.mana-and-artifice.inscription.ash_missing"),
        OUTPUT_FULL("gui.mana-and-artifice.inscription.output_full"),
        LOW_TIER("gui.mana-and-artifice.inscription.low_tier"),
        TOO_COMPLEX("gui.mana-and-artifice.inscription.too_complex"),
        WRONG_FACTION("gui.mana-and-artifice.inscription.wrong_faction"),
        ALREADY_CRAFTING(""),
        CANNOT_CHANNEL("gui.mana-and-artifice.inscription.component_not_channeled");

        private String lang_key;

        private CraftCheckResult(String lang_key) {
            this.lang_key = lang_key;
        }

        public String getTranslationKey() {
            return this.lang_key;
        }
    }
}

