/*
 * Decompiled with CFR 0.152.
 */
package com.ma.blocks.artifice;

import com.ma.api.items.MAItemGroups;
import com.ma.blocks.ICustomCategory;
import com.ma.blocks.WaterloggableBlock;
import com.ma.blocks.tileentities.LodestarTile;
import java.util.function.Consumer;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemGroup;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class LodestarBlock
extends WaterloggableBlock
implements ICustomCategory {
    public static final IntegerProperty SURFACE_TYPE = IntegerProperty.func_177719_a((String)"surface", (int)1, (int)3);
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;

    public LodestarBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151594_q).func_226896_b_().func_200948_a(5.0f, 1000.0f), false);
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{SURFACE_TYPE, FACING});
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction face;
        int surfaceType;
        if (context.func_196000_l() == Direction.UP) {
            surfaceType = 1;
            face = context.func_195992_f().func_176734_d();
        } else if (context.func_196000_l() == Direction.DOWN) {
            surfaceType = 2;
            face = context.func_195992_f().func_176734_d();
        } else {
            surfaceType = 3;
            face = context.func_196000_l();
        }
        return (BlockState)((BlockState)super.func_196258_a(context).func_206870_a((Property)FACING, (Comparable)face)).func_206870_a((Property)SURFACE_TYPE, (Comparable)Integer.valueOf(surfaceType));
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        LodestarTile lodestar;
        if (!worldIn.field_72995_K && (lodestar = (LodestarTile)worldIn.func_175625_s(pos)) != null) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)lodestar, (Consumer)lodestar);
        }
        return ActionResultType.SUCCESS;
    }

    public int getLightValue(BlockState state, IBlockReader world, BlockPos pos) {
        return 15;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new LodestarTile();
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            this.dropInventory(worldIn, pos);
        }
        super.func_196243_a(state, worldIn, pos, newState, isMoving);
    }

    private void dropInventory(World world, BlockPos pos) {
        if (world.field_72995_K) {
            return;
        }
        LodestarTile tileEntity = (LodestarTile)world.func_175625_s(pos);
        if (tileEntity != null) {
            for (int i = 0; i < tileEntity.getCommandCount(); ++i) {
                Inventory inv = tileEntity.getCommandInventory(i);
                InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)inv);
            }
        }
    }

    @Override
    public ItemGroup getItemGroup() {
        return MAItemGroups.constructs;
    }
}

