/*
 * Decompiled with CFR 0.152.
 */
package com.ma.api.spells.parts;

import com.google.common.collect.ImmutableList;
import com.ma.api.recipes.IMARecipe;
import com.ma.api.spells.SpellCraftingContext;
import com.ma.api.spells.SpellPartTags;
import com.ma.api.spells.SpellReagent;
import com.ma.api.spells.attributes.Attribute;
import com.ma.api.spells.attributes.AttributeValuePair;
import com.ma.api.spells.base.IModifiable;
import com.ma.api.spells.base.IModifiedSpellPart;
import com.ma.api.spells.base.ISpellComponent;
import com.ma.api.spells.base.ISpellDefinition;
import com.ma.api.spells.base.SpellBlacklistResult;
import com.ma.api.spells.targeting.SpellSource;
import com.ma.api.spells.targeting.SpellTarget;
import com.ma.config.MASpellConfig;
import com.ma.config.SpellModConfig;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.registries.ForgeRegistryEntry;

public abstract class Shape
extends ForgeRegistryEntry<Shape>
implements IModifiable,
ISpellComponent {
    private final ResourceLocation guiIcon;
    private Integer tier = null;
    private final ImmutableList<AttributeValuePair> modifiableAttributes;

    public Shape(ResourceLocation registryName, ResourceLocation guiIcon, AttributeValuePair ... attributeValuePairs) {
        this.guiIcon = guiIcon;
        this.setRegistryName(registryName);
        SpellModConfig.initForPart(MASpellConfig.BUILDER, this, attributeValuePairs);
        this.modifiableAttributes = ImmutableList.copyOf((Object[])attributeValuePairs);
    }

    @Override
    public final ImmutableList<AttributeValuePair> getModifiableAttributes() {
        return AttributeValuePair.deepCopy(this.modifiableAttributes);
    }

    public final void lookupAttributeConfig() {
        this.modifiableAttributes.forEach(m -> m.lookupConfig(this));
    }

    public abstract List<SpellTarget> Target(SpellSource var1, World var2, IModifiedSpellPart<Shape> var3, ISpellDefinition var4);

    public boolean spawnsTargetEntity() {
        return false;
    }

    @Override
    public boolean isCraftable(SpellCraftingContext context) {
        return true;
    }

    public boolean isChanneled() {
        return false;
    }

    public abstract float initialComplexity();

    @Override
    public SpellBlacklistResult canBeCastAt(World world, Vector3d position) {
        if (world.field_72995_K) {
            return SpellBlacklistResult.ALLOWED;
        }
        BlockPos bp = new BlockPos(position);
        Biome biome = world.func_226691_t_(bp);
        if (SpellModConfig.isDimensionBlacklisted(this, world.func_234923_W_().func_240901_a_())) {
            return SpellBlacklistResult.DIMENSION_BLOCKED;
        }
        if (SpellModConfig.isBiomeBlacklisted(this, biome.getRegistryName())) {
            return SpellBlacklistResult.BIOME_BLOCKED;
        }
        return SpellBlacklistResult.ALLOWED;
    }

    public int baselineCooldown() {
        return 0;
    }

    public int maxChannelTime(IModifiedSpellPart<Shape> shape) {
        return (int)shape.getValue(Attribute.DURATION) * 20;
    }

    @Override
    public boolean isUseableByPlayers() {
        return true;
    }

    @Override
    public final ResourceLocation getGuiIcon() {
        return this.guiIcon;
    }

    @Nullable
    public List<SpellReagent> getRequiredReagents(@Nullable PlayerEntity caster) {
        return null;
    }

    @Override
    public SpellPartTags getUseTag() {
        return SpellPartTags.NEUTRAL;
    }

    @Override
    public int getTier(World world) {
        if (this.tier == null) {
            Optional recipe = world.func_199532_z().func_215367_a(this.getRegistryName());
            this.tier = recipe.isPresent() && recipe.get() instanceof IMARecipe ? Integer.valueOf(((IMARecipe)recipe.get()).getTier()) : Integer.valueOf(0);
            if (this.tier < 0) {
                this.tier = 0;
            }
        }
        return this.tier;
    }

    public static class PhantomShape
    extends Shape {
        public static PhantomShape instance = new PhantomShape();
        private static final ResourceLocation _default = new ResourceLocation("mana-and-artifice:shape_default");

        public PhantomShape() {
            super(_default, _default, new AttributeValuePair[0]);
        }

        @Override
        public List<SpellTarget> Target(SpellSource source, World world, IModifiedSpellPart<Shape> modificationData, ISpellDefinition recipe) {
            return Arrays.asList(SpellTarget.NONE);
        }

        @Override
        public float initialComplexity() {
            return 0.0f;
        }

        @Override
        public int requiredXPForRote() {
            return -1;
        }

        @Override
        public SpellPartTags getUseTag() {
            return SpellPartTags.NEUTRAL;
        }
    }
}

