/*
 * Decompiled with CFR 0.152.
 */
package com.ma.api.spells.parts;

import com.google.common.collect.ImmutableList;
import com.ma.api.recipes.IMARecipe;
import com.ma.api.spells.SpellCraftingContext;
import com.ma.api.spells.SpellPartTags;
import com.ma.api.spells.attributes.Attribute;
import com.ma.api.spells.base.ISpellComponent;
import com.ma.api.spells.base.SpellBlacklistResult;
import java.util.Optional;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class Modifier
extends ForgeRegistryEntry<Modifier>
implements ISpellComponent {
    private final ResourceLocation guiIcon;
    private ImmutableList<Attribute> governed;
    private int xpToRote;
    private Integer tier;

    public Modifier(ResourceLocation guiIcon, int xpToRote, Attribute ... modified_attributes) {
        this.governed = ImmutableList.copyOf((Object[])modified_attributes);
        this.guiIcon = guiIcon;
        this.xpToRote = xpToRote;
    }

    public final boolean modifiesType(Attribute governing_attribute) {
        return this.governed.contains((Object)governing_attribute);
    }

    public final ImmutableList<Attribute> getModifiedAttributes() {
        return this.governed;
    }

    @Override
    public final ResourceLocation getGuiIcon() {
        return this.guiIcon;
    }

    @Override
    public boolean isCraftable(SpellCraftingContext context) {
        return true;
    }

    @Override
    public boolean isUseableByPlayers() {
        return true;
    }

    @Override
    public int requiredXPForRote() {
        return this.xpToRote;
    }

    @Override
    public SpellBlacklistResult canBeCastAt(World world, Vector3d position) {
        return SpellBlacklistResult.ALLOWED;
    }

    @Override
    public final SpellPartTags getUseTag() {
        return SpellPartTags.NEUTRAL;
    }

    @Override
    public int getTier(World world) {
        if (this.tier == null) {
            Optional recipe = world.func_199532_z().func_215367_a(this.getRegistryName());
            this.tier = recipe.isPresent() && recipe.get() instanceof IMARecipe ? Integer.valueOf(((IMARecipe)recipe.get()).getTier()) : Integer.valueOf(0);
            if (this.tier < 0) {
                this.tier = 0;
            }
        }
        return this.tier;
    }

    public static class PhantomModifier
    extends Modifier {
        private static final ResourceLocation _default = new ResourceLocation("mana-and-artifice:modifier_default");

        public PhantomModifier() {
            super(_default, -1, new Attribute[0]);
        }
    }
}

