/*
 * Decompiled with CFR 0.152.
 */
package com.ma.api.spells;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.IndirectEntityDamageSource;

public class DamageTypes {
    public static final String FROST = "ma-frost";
    public static final String LIGHTNING = "ma-lightning";
    public static final String BRIARS = "ma-briars";
    public static final String DISPERSE = "disperse";
    public static final String SHURIKEN = "shuriken";

    public static DamageSource causeSourcedShurikenDamage(LivingEntity source, ProjectileEntity shuriken) {
        return new IndirectEntityDamageSource(SHURIKEN, (Entity)shuriken, (Entity)source).func_151518_m().func_76349_b();
    }

    public static DamageSource causeShurikenDamage(ProjectileEntity shuriken) {
        return new IndirectEntityDamageSource(SHURIKEN, (Entity)shuriken, null).func_151518_m().func_76349_b();
    }

    public static DamageSource causeSourcedFireDamage(LivingEntity source) {
        return DamageTypes.createSourcedDamageType(source, DamageSource.field_76372_a);
    }

    public static DamageSource causeSourcedFrostDamage(LivingEntity source) {
        return new EntityDamageSource(FROST, (Entity)source).func_76348_h().func_82726_p();
    }

    public static DamageSource causeSourcedLightningDamage(LivingEntity source) {
        return new EntityDamageSource(LIGHTNING, (Entity)source).func_76348_h().func_82726_p();
    }

    public static DamageSource causeSourcedBriarDamage(LivingEntity source) {
        return new EntityDamageSource(BRIARS, (Entity)source);
    }

    public static DamageSource causeSourcedMagicDamage(LivingEntity source) {
        return DamageTypes.createSourcedDamageType(source, DamageSource.field_76376_m);
    }

    public static DamageSource causeSourcedDrownDamage(LivingEntity source) {
        return DamageTypes.createSourcedDamageType(source, DamageSource.field_76369_e);
    }

    public static DamageSource causeDispersionDamage() {
        return new DamageSource(DISPERSE).func_76348_h().func_151518_m().func_82726_p();
    }

    public static DamageSource causeFrostDamage() {
        return new DamageSource(FROST).func_76348_h().func_82726_p();
    }

    public static DamageSource causeLightningDamage() {
        return new DamageSource(LIGHTNING).func_76348_h().func_82726_p();
    }

    public static DamageSource causeBriarDamage() {
        return new DamageSource(BRIARS).func_76348_h().func_82726_p();
    }

    private static DamageSource createSourcedDamageType(LivingEntity source, DamageSource original) {
        Object copy_source = source != null ? new EntityDamageSource(original.field_76373_n, (Entity)source) : new DamageSource(original.field_76373_n);
        if (original.func_76357_e()) {
            copy_source.func_76359_i();
        }
        if (original.func_76363_c()) {
            copy_source.func_76348_h();
        }
        if (original.func_151517_h()) {
            copy_source.func_151518_m();
        }
        if (original.func_76350_n()) {
            copy_source.func_76351_m();
        }
        if (original.func_94541_c()) {
            copy_source.func_94540_d();
        }
        if (original.func_76347_k()) {
            copy_source.func_76361_j();
        }
        if (original.func_82725_o()) {
            copy_source.func_82726_p();
        }
        if (original.func_76352_a()) {
            copy_source.func_76349_b();
        }
        return copy_source;
    }

    public static DamageSource causeFortificationDamage(DamageSource damageType) {
        DamageSource copy = DamageTypes.createSourcedDamageType(damageType.func_76346_g() instanceof LivingEntity ? (LivingEntity)damageType.func_76346_g() : null, damageType);
        copy.func_151518_m();
        copy.func_76348_h();
        return copy;
    }
}

