/*
 * Decompiled with CFR 0.152.
 */
package com.ma.api.items;

import com.ma.api.ManaAndArtificeMod;
import com.ma.api.capabilities.IPlayerMagic;
import com.ma.api.items.ChargeableItem;
import com.ma.api.particles.MAParticleType;
import com.ma.api.particles.ParticleInit;
import com.ma.capabilities.playerdata.magic.PlayerMagicProvider;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class ManaBatteryItem
extends ChargeableItem {
    static final String KEY_MODE = "mana_crystal_fragment_mode";
    static final String KEY_MANA = "mana_crystal_fragment_mana";
    static final int MODE_INFUSE = 0;
    static final int MODE_SUPPLEMENT = 1;

    public ManaBatteryItem(Item.Properties properties, float maxMana) {
        super(properties, maxMana);
    }

    public int getMode(ItemStack stack) {
        if (!stack.func_77942_o() || !stack.func_77978_p().func_74764_b(KEY_MODE)) {
            return 0;
        }
        return stack.func_77978_p().func_74762_e(KEY_MODE);
    }

    protected void setMode(ItemStack stack, int mode) {
        stack.func_196082_o().func_74768_a(KEY_MODE, mode);
    }

    @Override
    public void onUsingTick(ItemStack stack, LivingEntity player, int count) {
        IPlayerMagic magic = (IPlayerMagic)player.getCapability(PlayerMagicProvider.MAGIC).orElse(null);
        if (magic == null || !(player instanceof PlayerEntity)) {
            return;
        }
        int mana_shift_amount = 10;
        switch (this.getMode(stack)) {
            case 1: {
                if (player.field_70170_p.field_72995_K) {
                    player.field_70170_p.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.BLUE_SPARKLE_GRAVITY.get())), player.func_226277_ct_() - 0.5 + Math.random(), player.func_226278_cu_() + Math.random(), player.func_226281_cx_() - 0.5 + Math.random(), 0.0, (double)0.1f, 0.0);
                    break;
                }
                if (!(magic.getCastingResource().getAmount() < magic.getCastingResource().getMaxAmount())) break;
                if (this.consumeMana(stack, mana_shift_amount, null)) {
                    magic.getCastingResource().restore(mana_shift_amount);
                    break;
                }
                player.func_184602_cy();
                break;
            }
            default: {
                if (player.field_70170_p.field_72995_K) {
                    player.field_70170_p.func_195594_a((IParticleData)new MAParticleType((ParticleType<MAParticleType>)((ParticleType)ParticleInit.BLUE_SPARKLE_GRAVITY.get())), player.func_226277_ct_() - 0.5 + Math.random(), player.func_226278_cu_() + Math.random(), player.func_226281_cx_() - 0.5 + Math.random(), 0.0, (double)0.1f, 0.0);
                    break;
                }
                if (magic.getCastingResource().getAmount() > (float)mana_shift_amount) {
                    if (this.refundMana(stack, mana_shift_amount, (PlayerEntity)player) > 0.0f) {
                        magic.getCastingResource().setAmount(magic.getCastingResource().getAmount() - (float)mana_shift_amount);
                        break;
                    }
                    player.func_184602_cy();
                    return;
                }
                player.func_184602_cy();
                return;
            }
        }
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (playerIn.func_225608_bj_()) {
            if (!worldIn.field_72995_K) {
                if (this.getMode(stack) == 0) {
                    this.setMode(stack, 1);
                } else {
                    this.setMode(stack, 0);
                }
            }
            return ActionResult.func_226248_a_((Object)stack);
        }
        if (this.getMode(stack) == 1) {
            if (this.getMana(stack) > 0.0f) {
                playerIn.getCapability(ManaAndArtificeMod.getMagicCapability()).ifPresent(m -> {
                    if (m.getCastingResource().canRechargeFrom(stack) && m.getCastingResource().getAmount() < m.getCastingResource().getMaxAmount()) {
                        playerIn.func_184598_c(handIn);
                    }
                });
            }
            return ActionResult.func_233538_a_((Object)stack, (boolean)worldIn.field_72995_K);
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    @Override
    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        switch (this.getMode(stack)) {
            case 1: {
                tooltip.add((ITextComponent)new TranslationTextComponent("item.mana-and-artifice.mana_battery.supplement").func_240699_a_(TextFormatting.AQUA));
                break;
            }
            default: {
                tooltip.add((ITextComponent)new TranslationTextComponent("item.mana-and-artifice.mana_battery.infusion").func_240699_a_(TextFormatting.AQUA));
            }
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc != null && mc.field_71439_g != null) {
            mc.field_71439_g.getCapability(ManaAndArtificeMod.getMagicCapability()).ifPresent(m -> {
                if (!m.getCastingResource().canRechargeFrom(stack)) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("item.mana-and-artifice.mana_battery.no_supplement").func_240699_a_(TextFormatting.RED));
                }
            });
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    @Override
    public boolean canContinueUsing(ItemStack oldStack, ItemStack newStack) {
        return this.getMode(newStack) == 0 ? this.getMana(newStack) < this.getMaxMana() : this.getMode(newStack) == 1 && this.getMana(newStack) >= 0.0f;
    }

    @Override
    protected boolean tickCurio() {
        return false;
    }

    @Override
    protected boolean tickInventory() {
        return false;
    }

    @Override
    protected boolean tickEffect(ItemStack stack, PlayerEntity player, World world, int slot, float mana, boolean selected) {
        return false;
    }
}

