/*
 * Decompiled with CFR 0.152.
 */
package com.ma.api.capabilities.resource;

import com.ma.api.capabilities.resource.SyncStatus;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;

public interface ICastingResource {
    public ResourceLocation getRegistryName();

    public SyncStatus getSyncStatus();

    public void clearSyncStatus();

    public float getAmount();

    public void setAmount(float var1);

    public void consume(float var1);

    public void restore(float var1);

    public float getMaxAmount();

    public float getMaxAmountBaseline();

    public void setMaxAmount(float var1);

    public void setMaxAmountByLevel(int var1);

    public void addModifier(String var1, float var2);

    public HashMap<String, Float> getModifiers();

    public void removeModifier(String var1);

    public void clearModifiers();

    public int getRegenerationRate();

    public void setRegenerationRate(int var1);

    public void addRegenerationModifier(String var1, float var2);

    public HashMap<String, Float> getRegenerationModifiers();

    public void removeRegenerationModifier(String var1);

    public void clearRegenerationModifiers();

    public float getRegenerationModifier();

    default public boolean hungerAffectsRegenRate() {
        return true;
    }

    default public boolean canRechargeFrom(ItemStack batteryItem) {
        return true;
    }

    default public void copyFrom(ICastingResource other) {
        if (other.getRegistryName() != this.getRegistryName()) {
            return;
        }
        this.clearModifiers();
        other.getModifiers().forEach((k, v) -> this.addModifier((String)k, v.floatValue()));
        this.clearRegenerationModifiers();
        other.getRegenerationModifiers().forEach((k, v) -> this.addRegenerationModifier((String)k, v.floatValue()));
        this.setMaxAmount(other.getMaxAmount());
        this.setAmount(other.getAmount());
        this.setRegenerationRate(other.getRegenerationRate());
    }

    default public void writeNBT(CompoundNBT nbt) {
        CompoundNBT resourceNBT = new CompoundNBT();
        resourceNBT.func_74776_a("amount", this.getAmount());
        resourceNBT.func_74776_a("maximum", this.getMaxAmountBaseline());
        ListNBT maximumModifiers = new ListNBT();
        for (Map.Entry<String, Float> entry : this.getModifiers().entrySet()) {
            CompoundNBT modifier = new CompoundNBT();
            modifier.func_74778_a("key", entry.getKey());
            modifier.func_74776_a("value", entry.getValue().floatValue());
            maximumModifiers.add((Object)modifier);
        }
        resourceNBT.func_218657_a("maximum_modifiers", (INBT)maximumModifiers);
        ListNBT regenerationModifiers = new ListNBT();
        for (Map.Entry<String, Float> entry : this.getRegenerationModifiers().entrySet()) {
            CompoundNBT modifier = new CompoundNBT();
            modifier.func_74778_a("key", entry.getKey());
            modifier.func_74776_a("value", entry.getValue().floatValue());
            regenerationModifiers.add((Object)modifier);
        }
        resourceNBT.func_218657_a("regeneration_modifiers", (INBT)regenerationModifiers);
        nbt.func_218657_a(this.getRegistryName().toString(), (INBT)resourceNBT);
    }

    default public void readNBT(CompoundNBT nbt) {
        if (nbt.func_74764_b(this.getRegistryName().toString())) {
            CompoundNBT resourceNBT = nbt.func_74775_l(this.getRegistryName().toString());
            ListNBT maximumModifiers = resourceNBT.func_150295_c("maximum_modifiers", 10);
            this.getModifiers().clear();
            maximumModifiers.forEach(inbt -> this.getModifiers().put(((CompoundNBT)inbt).func_74779_i("key"), Float.valueOf(((CompoundNBT)inbt).func_74760_g("value"))));
            ListNBT regenerationModifiers = resourceNBT.func_150295_c("regeneration_modifiers", 10);
            this.getRegenerationModifiers().clear();
            regenerationModifiers.forEach(inbt -> this.getRegenerationModifiers().put(((CompoundNBT)inbt).func_74779_i("key"), Float.valueOf(((CompoundNBT)inbt).func_74760_g("value"))));
            this.setAmount(resourceNBT.func_74760_g("amount"));
            this.setMaxAmount(resourceNBT.func_74760_g("maximum"));
        }
    }

    public void setNeedsSync();
}

