/*
 * Decompiled with CFR 0.152.
 */
package com.ma.api.blocks.tile;

import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class TileEntityWithInventory
extends TileEntity
implements IInventory,
ISidedInventory {
    protected NonNullList<ItemStack> inventoryItems;
    protected boolean ignoreQtyLimit = false;
    protected HashMap<Direction, LazyOptional<?>> sidedHandlers;

    public TileEntityWithInventory(TileEntityType<?> tileEntityTypeIn, int inventorySize) {
        super(tileEntityTypeIn);
        this.inventoryItems = NonNullList.func_191197_a((int)inventorySize, (Object)ItemStack.field_190927_a);
        this.sidedHandlers = new HashMap();
    }

    protected LazyOptional<?> getOrCreateSidedHandler(Direction side) {
        if (!this.sidedHandlers.containsKey(side)) {
            this.sidedHandlers.put(side, LazyOptional.of(() -> new SidedInvWrapper((ISidedInventory)this, side)));
        }
        return this.sidedHandlers.get(side);
    }

    @Nullable
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (!this.field_145846_f && cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.getOrCreateSidedHandler(side).cast();
        }
        return super.getCapability(cap, side);
    }

    public void func_174888_l() {
        this.func_70296_d();
        this.inventoryItems.clear();
    }

    public int func_70302_i_() {
        return this.inventoryItems.size();
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.inventoryItems) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.inventoryItems.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack output = ItemStackHelper.func_188382_a(this.inventoryItems, (int)index, (int)count);
        this.func_70296_d();
        return output;
    }

    public ItemStack func_70304_b(int index) {
        ItemStack itemstack = (ItemStack)this.inventoryItems.get(index);
        if (itemstack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        this.inventoryItems.set(index, (Object)ItemStack.field_190927_a);
        this.func_70296_d();
        return itemstack;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.inventoryItems.set(index, (Object)stack);
        if (!this.ignoreQtyLimit && !stack.func_190926_b() && stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        this.func_70296_d();
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, Direction direction) {
        return false;
    }

    public int[] func_180463_a(Direction side) {
        return new int[0];
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        return false;
    }

    public boolean func_70300_a(PlayerEntity player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return this.func_174877_v().func_177963_a(0.5, 0.5, 0.5).func_218137_a((IPosition)player.func_213303_ch(), 8.0);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        ItemStackHelper.func_191282_a((CompoundNBT)compound, this.inventoryItems);
        return super.func_189515_b(compound);
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        ItemStackHelper.func_191283_b((CompoundNBT)compound, this.inventoryItems);
        super.func_230337_a_(state, compound);
    }
}

