/*
 * Decompiled with CFR 0.152.
 */
package com.ma.api.blocks.tile;

import java.util.function.Predicate;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;

public class BlockPosCache {
    public static final int MAX_BLOCKS_CHECKED_PER_TICK = 50;
    private AxisAlignedBB powerSearchArea = null;
    private NonNullList<BlockPos> cachedBlocks;
    private boolean searchingSurroundings = false;
    private BlockPos lastSearchPos;
    int searchRadius;
    private final TileEntity parent;
    private final Predicate<BlockPos> blockValidCheck;

    public BlockPosCache(TileEntity parent, int radius, Predicate<BlockPos> blockValid) {
        this.searchRadius = radius;
        this.cachedBlocks = NonNullList.func_191196_a();
        this.parent = parent;
        this.blockValidCheck = blockValid;
    }

    public void tick() {
        if (this.searchingSurroundings) {
            this.search();
        }
    }

    public void search() {
        int x = this.lastSearchPos.func_177958_n();
        int y = this.lastSearchPos.func_177956_o();
        int z = this.lastSearchPos.func_177952_p();
        int count = 0;
        while ((double)x <= this.powerSearchArea.field_72336_d) {
            while ((double)y <= this.powerSearchArea.field_72337_e) {
                while ((double)z <= this.powerSearchArea.field_72334_f) {
                    BlockPos curSearch = new BlockPos(x, y, z);
                    if (this.parent.func_145831_w().func_195588_v(curSearch) && this.blockValidCheck.test(curSearch)) {
                        this.cachedBlocks.add((Object)curSearch);
                    }
                    if (++count >= 50) {
                        this.lastSearchPos = new BlockPos(x, y, z);
                        return;
                    }
                    ++z;
                }
                z = (int)this.powerSearchArea.field_72339_c;
                ++y;
            }
            y = (int)this.powerSearchArea.field_72338_b;
            ++x;
        }
        this.searchingSurroundings = false;
    }

    public NonNullList<BlockPos> getCachedPositions() {
        return this.cachedBlocks;
    }

    public void queueRecheck() {
        this.searchingSurroundings = true;
        this.cachedBlocks.clear();
        BlockPos myPos = this.parent.func_174877_v();
        this.powerSearchArea = new AxisAlignedBB(myPos).func_186662_g((double)this.searchRadius);
        this.lastSearchPos = new BlockPos((int)this.powerSearchArea.field_72340_a, (int)this.powerSearchArea.field_72338_b, (int)this.powerSearchArea.field_72339_c);
    }

    public boolean isSearching() {
        return this.searchingSurroundings;
    }
}

