/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.util;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.TridentEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import stepsword.mahoutsukai.capability.caliburn.CaliburnMahouProvider;
import stepsword.mahoutsukai.capability.caliburn.ICaliburnMahou;
import stepsword.mahoutsukai.capability.chunks.ChunkMahouProvider;
import stepsword.mahoutsukai.capability.chunks.IChunkMahou;
import stepsword.mahoutsukai.capability.containers.MysticCodeInventoryProvider;
import stepsword.mahoutsukai.capability.gemmahou.GemMahouProvider;
import stepsword.mahoutsukai.capability.gemmahou.IGemMahou;
import stepsword.mahoutsukai.capability.kodoku.IKodokuMahou;
import stepsword.mahoutsukai.capability.kodoku.KodokuMahouProvider;
import stepsword.mahoutsukai.capability.lance.ILanceMahou;
import stepsword.mahoutsukai.capability.lance.LanceMahouProvider;
import stepsword.mahoutsukai.capability.livingmahou.ILivingMahou;
import stepsword.mahoutsukai.capability.livingmahou.LivingMahouProvider;
import stepsword.mahoutsukai.capability.mahou.IMahou;
import stepsword.mahoutsukai.capability.mahou.MahouProvider;
import stepsword.mahoutsukai.capability.scrollmahou.IScrollMahou;
import stepsword.mahoutsukai.capability.scrollmahou.ScrollMahouProvider;
import stepsword.mahoutsukai.capability.settingsmahou.ISettingsMahou;
import stepsword.mahoutsukai.capability.settingsmahou.SettingsMahouProvider;
import stepsword.mahoutsukai.capability.worldsave.IWorldMahou;
import stepsword.mahoutsukai.capability.worldsave.WorldMahouProvider;
import stepsword.mahoutsukai.entity.WeaponProjectileEntity;
import stepsword.mahoutsukai.fluids.ModFluids;
import stepsword.mahoutsukai.util.EffectUtil;

public class Utils {
    public static IMahou getPlayerMahou(PlayerEntity player) {
        try {
            LazyOptional lazy = player.getCapability(MahouProvider.MAHOU, null);
            return (IMahou)lazy.orElseThrow(RuntimeException::new);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static ILivingMahou getLivingMahou(LivingEntity player) {
        try {
            LazyOptional lazy = player.getCapability(LivingMahouProvider.MAHOU, null);
            return (ILivingMahou)lazy.orElseThrow(RuntimeException::new);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static ISettingsMahou getSettingsMahou(LivingEntity player) {
        try {
            LazyOptional lazy = player.getCapability(SettingsMahouProvider.MAHOU, null);
            return (ISettingsMahou)lazy.orElseThrow(RuntimeException::new);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static IItemHandler getInventory(ItemStack stack) {
        try {
            LazyOptional lazy = stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            return (IItemHandler)lazy.orElseThrow(RuntimeException::new);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static IItemHandler getInventory(LivingEntity e) {
        try {
            LazyOptional lazy = e.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            return (IItemHandler)lazy.orElseThrow(RuntimeException::new);
        }
        catch (Exception xe) {
            return null;
        }
    }

    public static IItemHandler getMCInventory(ItemStack stack) {
        try {
            LazyOptional lazy = stack.getCapability(MysticCodeInventoryProvider.MYSTIC_CODE_INVENTORY, null);
            return (IItemHandler)lazy.orElseThrow(RuntimeException::new);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static IItemHandler getInventory(TileEntity stack) {
        try {
            LazyOptional lazy = stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            return (IItemHandler)lazy.orElseThrow(RuntimeException::new);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static IGemMahou getGemMahou(ItemStack stack) {
        try {
            LazyOptional lazy = stack.getCapability(GemMahouProvider.MAHOU, null);
            return (IGemMahou)lazy.orElseThrow(RuntimeException::new);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static IScrollMahou getScrollMahou(ItemStack stack) {
        try {
            LazyOptional lazy = stack.getCapability(ScrollMahouProvider.MAHOU, null);
            return (IScrollMahou)lazy.orElseThrow(RuntimeException::new);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static ICaliburnMahou getCaliburnMahou(ItemStack stack) {
        try {
            LazyOptional lazy = stack.getCapability(CaliburnMahouProvider.MAHOU, null);
            return (ICaliburnMahou)lazy.orElseThrow(RuntimeException::new);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static ILanceMahou getLanceMahou(ItemStack stack) {
        try {
            LazyOptional lazy = stack.getCapability(LanceMahouProvider.MAHOU, null);
            return (ILanceMahou)lazy.orElseThrow(RuntimeException::new);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static IKodokuMahou getKodokuMahou(ItemStack stack) {
        try {
            LazyOptional lazy = stack.getCapability(KodokuMahouProvider.MAHOU, null);
            return (IKodokuMahou)lazy.orElseThrow(RuntimeException::new);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static IWorldMahou getWorldMahou(World world) {
        try {
            LazyOptional lazy = world.getCapability(WorldMahouProvider.MAHOU, null);
            return (IWorldMahou)lazy.orElseThrow(RuntimeException::new);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static IChunkMahou getChunkMahou(Chunk chunk) {
        try {
            LazyOptional lazy = chunk.getCapability(ChunkMahouProvider.MAHOU, null);
            return (IChunkMahou)lazy.orElseThrow(RuntimeException::new);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean isBlockAir(World world, BlockPos pos) {
        Block b = world.func_180495_p(pos).func_177230_c();
        return b.isAir(world.func_180495_p(pos), (IBlockReader)world, pos) || b == Blocks.field_150350_a || b == Blocks.field_201941_jj || b == Blocks.field_201940_ji;
    }

    public static RayTraceResult rayTraceEyes(LivingEntity entity, double length) {
        Vector3d startPos = new Vector3d(entity.func_226277_ct_(), entity.func_226278_cu_() + (double)entity.func_70047_e(), entity.func_226281_cx_());
        Vector3d endPos = startPos.func_178787_e(new Vector3d(entity.func_70040_Z().field_72450_a * length, entity.func_70040_Z().field_72448_b * length, entity.func_70040_Z().field_72449_c * length));
        return entity.field_70170_p.func_217299_a(new RayTraceContext(startPos, endPos, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.SOURCE_ONLY, (Entity)entity));
    }

    public static boolean isInMurkyWater(Entity entity) {
        double eyes = entity.func_226278_cu_() + (double)entity.func_70047_e();
        BlockState state = entity.field_70170_p.func_180495_p(new BlockPos(entity.func_174824_e(1.0f)));
        Block block = state.func_177230_c();
        double filled = 0.0;
        if (block instanceof FlowingFluidBlock && (((FlowingFluidBlock)block).getFluid() == ModFluids.MURKY_FLOW.get() || ((FlowingFluidBlock)block).getFluid() == ModFluids.MURKY_STILL.get())) {
            double h;
            filled = h = (double)((FlowingFluidBlock)block).func_204507_t(state).func_223408_f() + 0.1111111111111111;
        }
        return eyes - Math.floor(eyes) < filled;
    }

    public static World getWorldFromDimension(RegistryKey<World> dim, ServerWorld world) {
        return world.func_73046_m().func_71218_a(dim);
    }

    public static boolean GetIntersection(double fDst1, double fDst2, Vector3d P1, Vector3d P2, Vector3dH Hit) {
        if (fDst1 * fDst2 >= 0.0) {
            return false;
        }
        if (fDst1 == fDst2) {
            return false;
        }
        Hit.v = P1.func_178787_e(P2.func_178788_d(P1).func_186678_a(-fDst1 / (fDst2 - fDst1)));
        return true;
    }

    public static boolean InBox(Vector3d Hit, Vector3d B1, Vector3d B2, int Axis) {
        if (Axis == 1 && Hit.field_72449_c > B1.field_72449_c && Hit.field_72449_c < B2.field_72449_c && Hit.field_72448_b > B1.field_72448_b && Hit.field_72448_b < B2.field_72448_b) {
            return true;
        }
        if (Axis == 2 && Hit.field_72449_c > B1.field_72449_c && Hit.field_72449_c < B2.field_72449_c && Hit.field_72450_a > B1.field_72450_a && Hit.field_72450_a < B2.field_72450_a) {
            return true;
        }
        return Axis == 3 && Hit.field_72450_a > B1.field_72450_a && Hit.field_72450_a < B2.field_72450_a && Hit.field_72448_b > B1.field_72448_b && Hit.field_72448_b < B2.field_72448_b;
    }

    public static boolean CheckLineBox(Vector3d B1, Vector3d B2, Vector3d L1, Vector3d L2, Vector3dH Hit) {
        if (L2.field_72450_a < B1.field_72450_a && L1.field_72450_a < B1.field_72450_a) {
            return false;
        }
        if (L2.field_72450_a > B2.field_72450_a && L1.field_72450_a > B2.field_72450_a) {
            return false;
        }
        if (L2.field_72448_b < B1.field_72448_b && L1.field_72448_b < B1.field_72448_b) {
            return false;
        }
        if (L2.field_72448_b > B2.field_72448_b && L1.field_72448_b > B2.field_72448_b) {
            return false;
        }
        if (L2.field_72449_c < B1.field_72449_c && L1.field_72449_c < B1.field_72449_c) {
            return false;
        }
        if (L2.field_72449_c > B2.field_72449_c && L1.field_72449_c > B2.field_72449_c) {
            return false;
        }
        if (L1.field_72450_a > B1.field_72450_a && L1.field_72450_a < B2.field_72450_a && L1.field_72448_b > B1.field_72448_b && L1.field_72448_b < B2.field_72448_b && L1.field_72449_c > B1.field_72449_c && L1.field_72449_c < B2.field_72449_c) {
            Hit.v = L1;
            return true;
        }
        return Utils.GetIntersection(L1.field_72450_a - B1.field_72450_a, L2.field_72450_a - B1.field_72450_a, L1, L2, Hit) && Utils.InBox(Hit.v, B1, B2, 1) || Utils.GetIntersection(L1.field_72448_b - B1.field_72448_b, L2.field_72448_b - B1.field_72448_b, L1, L2, Hit) && Utils.InBox(Hit.v, B1, B2, 2) || Utils.GetIntersection(L1.field_72449_c - B1.field_72449_c, L2.field_72449_c - B1.field_72449_c, L1, L2, Hit) && Utils.InBox(Hit.v, B1, B2, 3) || Utils.GetIntersection(L1.field_72450_a - B2.field_72450_a, L2.field_72450_a - B2.field_72450_a, L1, L2, Hit) && Utils.InBox(Hit.v, B1, B2, 1) || Utils.GetIntersection(L1.field_72448_b - B2.field_72448_b, L2.field_72448_b - B2.field_72448_b, L1, L2, Hit) && Utils.InBox(Hit.v, B1, B2, 2) || Utils.GetIntersection(L1.field_72449_c - B2.field_72449_c, L2.field_72449_c - B2.field_72449_c, L1, L2, Hit) && Utils.InBox(Hit.v, B1, B2, 3);
    }

    public static boolean CheckLineBox(Vector3d B1, Vector3d B2, Vector3d L1, Vector3d L2) {
        return Utils.CheckLineBox(B1, B2, L1, L2, new Vector3dH(L1));
    }

    public static CompoundNBT blockposToNBT(BlockPos p, String name) {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74768_a(name + "_x", p.func_177958_n());
        nbt.func_74768_a(name + "_y", p.func_177956_o());
        nbt.func_74768_a(name + "_z", p.func_177952_p());
        return nbt;
    }

    public static BlockPos NBTtoBlockPos(CompoundNBT nbt, String name) {
        BlockPos ret = null;
        if (nbt.func_74764_b(name + "_x") && nbt.func_74764_b(name + "_y") && nbt.func_74764_b(name + "_z")) {
            ret = new BlockPos(nbt.func_74762_e(name + "_x"), nbt.func_74762_e(name + "_y"), nbt.func_74762_e(name + "_z"));
        }
        return ret;
    }

    public static void writeIntListToBuffer(ByteBuf buf, List<Integer> lst) {
        buf.writeInt(lst.size());
        for (Integer i : lst) {
            buf.writeInt(i.intValue());
        }
    }

    public static List<Integer> readIntListFromBuffer(ByteBuf buf) {
        ArrayList<Integer> lst = new ArrayList<Integer>();
        int sz = buf.readInt();
        for (int i = 0; i < sz; ++i) {
            lst.add(buf.readInt());
        }
        return lst;
    }

    public static void color(ItemStack stack, float r, float g, float b, float r2, float g2, float b2) {
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt == null) {
            nbt = new CompoundNBT();
        }
        nbt.func_74776_a("mahou_r", r);
        nbt.func_74776_a("mahou_g", g);
        nbt.func_74776_a("mahou_b", b);
        nbt.func_74776_a("mahou_r2", r2);
        nbt.func_74776_a("mahou_g2", g2);
        nbt.func_74776_a("mahou_b2", b2);
        stack.func_77982_d(nbt);
    }

    public static float[] getColor(ItemStack stack) {
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt == null) {
            return null;
        }
        if (nbt.func_74764_b("mahou_r") && nbt.func_74764_b("mahou_g") && nbt.func_74764_b("mahou_b") && nbt.func_74764_b("mahou_r2") && nbt.func_74764_b("mahou_g2") && nbt.func_74764_b("mahou_b2")) {
            return new float[]{nbt.func_74760_g("mahou_r"), nbt.func_74760_g("mahou_g"), nbt.func_74760_g("mahou_b"), nbt.func_74760_g("mahou_r2"), nbt.func_74760_g("mahou_g2"), nbt.func_74760_g("mahou_b2")};
        }
        return null;
    }

    public static float avgStep(float a, float b, float steps, float step) {
        float diff = Math.abs(b - a);
        float onestep = diff / steps;
        if (a < b) {
            return a + onestep * step;
        }
        return a - onestep * step;
    }

    public static float[][] permute(float[][] in, int offset) {
        float[][] ret = new float[in.length][in[0].length];
        for (int i = 0; i < in.length; ++i) {
            for (int j = 0; j < in[0].length; ++j) {
                ret[Math.floorMod((int)(i + offset), (int)in.length)][j] = in[i][j];
            }
        }
        return ret;
    }

    public static ArrayList<BlockPos> findTilesInRange(LivingEntity player, int range, Predicate<TileEntity> pred) {
        int bx = (int)(player.func_213303_ch().field_72450_a - (double)range);
        int bz = (int)(player.func_213303_ch().field_72449_c - (double)range);
        int tx = (int)(player.func_213303_ch().field_72450_a + (double)range);
        int tz = (int)(player.func_213303_ch().field_72449_c + (double)range);
        ChunkPos bp = new ChunkPos(new BlockPos(bx, 0, bz));
        ChunkPos tp = new ChunkPos(new BlockPos(tx, 0, tz));
        ArrayList<BlockPos> lst = new ArrayList<BlockPos>();
        for (int x = bp.field_77276_a; x <= tp.field_77276_a; ++x) {
            for (int z = bp.field_77275_b; z <= tp.field_77275_b; ++z) {
                Chunk c = player.field_70170_p.func_212866_a_(x, z);
                Map m = c.func_177434_r();
                for (BlockPos pos : m.keySet()) {
                    if (!pred.test((TileEntity)m.get(pos))) continue;
                    lst.add(pos);
                }
            }
        }
        return lst;
    }

    public static double distanceToLine(Vector3d v, Vector3d w, Vector3d p) {
        Vector3d VW = v.func_178788_d(w);
        if (VW.func_189985_c() == 0.0) {
            return p.func_72438_d(v);
        }
        Vector3d z = v.func_178788_d(VW.func_186678_a(v.func_178788_d(p).func_72430_b(VW) / VW.func_72430_b(VW)));
        double dv = z.func_72436_e(v);
        double dw = z.func_72436_e(w);
        double dvw = v.func_72436_e(w);
        if (dv > dvw) {
            return p.func_72438_d(w);
        }
        if (dw > dvw) {
            return p.func_72438_d(v);
        }
        return p.func_72438_d(z);
    }

    public static Entity selectEntityNearCursor(PlayerEntity player, double distance, World world, Predicate<Entity> pred, boolean nearAllowed) {
        Entity ret = null;
        if (player != null) {
            List lst = world.func_175674_a((Entity)player, player.func_174813_aQ().func_186662_g(distance), pred);
            Vector3d eyes = player.func_174824_e(1.0f);
            Vector3d look = player.func_70040_Z();
            Vector3d sightEnd = eyes.func_178787_e(look.func_186678_a(distance));
            double minDToLine = Double.MAX_VALUE;
            double minD = Double.MAX_VALUE;
            boolean intersects = false;
            for (Entity e : lst) {
                Vector3d center;
                double dToLine;
                AxisAlignedBB aabb = e.func_174813_aQ();
                double d = e.func_213303_ch().func_72438_d(eyes);
                if (Utils.CheckLineBox(new Vector3d(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c), new Vector3d(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f), eyes, sightEnd)) {
                    intersects = true;
                    if (d < minD && !Utils.blockBetween(eyes, e.func_174813_aQ().func_189972_c(), e.field_70170_p)) {
                        ret = e;
                        minD = d;
                    }
                }
                if (!nearAllowed || intersects || !((dToLine = Utils.distanceToLine(eyes, sightEnd, center = aabb.func_189972_c())) < minDToLine) || Utils.blockBetween(eyes, e.func_174813_aQ().func_189972_c(), e.field_70170_p) || !EffectUtil.isLookingAtMe(e, (LivingEntity)player, 45)) continue;
                minDToLine = dToLine;
                ret = e;
            }
        }
        return ret;
    }

    public static boolean blockBetween(Vector3d e1, Vector3d e2, World world) {
        Vector3d subtracted = e2.func_178788_d(e1);
        Vector3d unit = subtracted.func_72432_b();
        if (subtracted.func_72433_c() > 1.0) {
            int i = 0;
            while ((double)i < subtracted.func_72433_c()) {
                BlockPos pos = new BlockPos(e1.func_178787_e(unit.func_186678_a((double)i)));
                BlockState bs = world.func_180495_p(pos);
                if (!bs.func_177230_c().isAir(bs, (IBlockReader)world, pos) && !bs.func_177230_c().func_200123_i(bs, (IBlockReader)world, pos)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        return false;
    }

    public static boolean getPredicate(MAHOU_SELECTION s, Entity e, PlayerEntity player) {
        return Utils.getPredicate(new HashSet<MAHOU_SELECTION>(Collections.singleton(s)), e, player);
    }

    public static boolean getPredicate(HashSet<MAHOU_SELECTION> set, Entity e, PlayerEntity player) {
        if (set.contains((Object)MAHOU_SELECTION.SELECTIVE_DISPLACEMENT)) {
            return e != player;
        }
        if (set.contains((Object)MAHOU_SELECTION.SCROLL_PROJECTION)) {
            return e != player && (e instanceof LivingEntity || e instanceof ItemEntity || e instanceof TridentEntity || e instanceof ItemFrameEntity || e instanceof WeaponProjectileEntity);
        }
        if (set.contains((Object)MAHOU_SELECTION.SCROLL_GEAS)) {
            return e != player && (e instanceof LivingEntity || e instanceof ItemEntity);
        }
        if (set.size() > 0) {
            return e != player && e instanceof LivingEntity;
        }
        return false;
    }

    public static boolean nearAllowed(MAHOU_SELECTION s) {
        return Utils.nearAllowed(new HashSet<MAHOU_SELECTION>(Collections.singleton(s)));
    }

    public static boolean nearAllowed(HashSet<MAHOU_SELECTION> set) {
        return set.contains((Object)MAHOU_SELECTION.SELECTIVE_DISPLACEMENT) || set.contains((Object)MAHOU_SELECTION.SCROLL_RETRIBUTION) || set.contains((Object)MAHOU_SELECTION.SCROLL_POSSESS_ENTITY) || set.contains((Object)MAHOU_SELECTION.SCROLL_DAMAGE_REPLICATION) || set.contains((Object)MAHOU_SELECTION.INSIGHT) || set.contains((Object)MAHOU_SELECTION.WEAPON);
    }

    public static enum MAHOU_SELECTION {
        SELECTIVE_DISPLACEMENT,
        SCROLL_PROJECTION,
        SCROLL_RETRIBUTION,
        SCROLL_POSSESS_ENTITY,
        SCROLL_DAMAGE_REPLICATION,
        SCROLL_IMMUNITY_EXCHANGE,
        SCROLL_GEAS,
        SCROLL_REALITY_MARBLE,
        WEAPON,
        WEAPON_NO_NEAR,
        INSIGHT,
        RIPPER_FOG;

    }

    public static class Vector3dH {
        public Vector3d v;

        public Vector3dH(Vector3d vec) {
            this.v = vec;
        }
    }
}

