/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.render.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import io.netty.util.internal.ConcurrentSet;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.eventbus.api.Event;
import stepsword.mahoutsukai.block.ModBlocks;
import stepsword.mahoutsukai.capability.chunks.IChunkMahou;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.render.gui.FogProjectorScreen;
import stepsword.mahoutsukai.tile.FogProjectorTileEntity;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class RenderFogProjectors {
    public static ConcurrentSet<FogProjectorTileEntity> distanceToFog(Entity entity) {
        int r = (int)MTConfig.FOG_PROJECTOR_MAX_RADIUS;
        BlockPos minPos = entity.func_233580_cy_().func_177982_a(-r, -r, -r);
        BlockPos maxPos = entity.func_233580_cy_().func_177982_a(r, r, r);
        ChunkPos minCPos = new ChunkPos(minPos);
        ChunkPos maxCPos = new ChunkPos(maxPos);
        ConcurrentSet ret = new ConcurrentSet();
        try {
            for (int x = minCPos.field_77276_a; x < maxCPos.field_77276_a + 1; ++x) {
                for (int z = minCPos.field_77275_b; z < maxCPos.field_77275_b + 1; ++z) {
                    IChunkMahou chunkMahou;
                    ConcurrentSet<BlockPos> blocks;
                    Chunk c = entity.field_70170_p.func_212866_a_(x, z);
                    if (!(c instanceof Chunk) || (blocks = (chunkMahou = Utils.getChunkMahou(c)).getFogProjectors()) == null || blocks.size() <= 0) continue;
                    for (BlockPos p : blocks) {
                        TileEntity be;
                        Block b = entity.field_70170_p.func_180495_p(p).func_177230_c();
                        if (b != ModBlocks.fogProjector || Math.abs(p.func_177958_n() - entity.func_233580_cy_().func_177958_n()) >= r || Math.abs(p.func_177952_p() - entity.func_233580_cy_().func_177952_p()) >= r || Math.abs(p.func_177956_o() - entity.func_233580_cy_().func_177956_o()) >= r || !((be = entity.field_70170_p.func_175625_s(p)) instanceof FogProjectorTileEntity) || !((FogProjectorTileEntity)be).get_camera_fog_toggle() || entity.field_70170_p.func_175640_z(p)) continue;
                        ret.add((Object)((FogProjectorTileEntity)be));
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public static boolean fogProjectorColor(EntityViewRenderEvent.FogColors event) {
        boolean ret = false;
        double td = 0.0;
        double tr = 0.0;
        double tg = 0.0;
        double tb = 0.0;
        boolean doChange = false;
        ConcurrentSet<FogProjectorTileEntity> blocks = RenderFogProjectors.distanceToFog(Minecraft.func_71410_x().func_175606_aa());
        for (FogProjectorTileEntity te : blocks) {
            Vector3d v = EffectUtil.fromBlockPos(te.func_174877_v()).func_72441_c(0.5, 0.5, 0.5);
            double d = v.func_72438_d(Minecraft.func_71410_x().func_175606_aa().func_213303_ch());
            if (d <= 0.0) {
                d = 1.0E-8;
            }
            if (!(d < (double)te.get_camera_fog_radius())) continue;
            double colorstrength = ((double)te.get_camera_fog_radius() - d) / (double)te.get_camera_fog_radius();
            td += (colorstrength *= 2.0);
            tr += (double)te.get_camera_fog_color_r() * colorstrength;
            tg += (double)te.get_camera_fog_color_g() * colorstrength;
            tb += (double)te.get_camera_fog_color_b() * colorstrength;
            doChange = true;
        }
        td += 1.0;
        tr += (double)(event.getRed() * 255.0f);
        tg += (double)(event.getGreen() * 255.0f);
        tb += (double)(event.getBlue() * 255.0f);
        if (td > 0.0 && doChange) {
            float r = (float)(tr / td / 255.0);
            float g = (float)(tg / td / 255.0);
            float b = (float)(tb / td / 255.0);
            event.setRed(r);
            event.setGreen(g);
            event.setBlue(b);
            ret = true;
        }
        return ret;
    }

    public static boolean fogProjectorRenderFog(EntityViewRenderEvent.RenderFogEvent event) {
        boolean ret = RenderFogProjectors.doFog(event.getType(), event.getFarPlaneDistance());
        if (ret) {
            event.setResult(Event.Result.ALLOW);
        }
        return ret;
    }

    public static double getStrength() {
        double strength = 0.0;
        ConcurrentSet<FogProjectorTileEntity> blocks = RenderFogProjectors.distanceToFog(Minecraft.func_71410_x().func_175606_aa());
        for (FogProjectorTileEntity te : blocks) {
            Vector3d v = EffectUtil.fromBlockPos(te.func_174877_v()).func_72441_c(0.5, 0.5, 0.5);
            double d = v.func_72438_d(Minecraft.func_71410_x().func_175606_aa().func_213303_ch());
            if (!(d < (double)te.get_camera_fog_radius())) continue;
            strength += (double)te.get_camera_fog_strength() - (double)(te.get_camera_fog_strength() / te.get_camera_fog_radius()) * d;
        }
        return strength;
    }

    public static boolean doFog(FogRenderer.FogType type, float farPlane) {
        boolean ret = false;
        double strength = RenderFogProjectors.getStrength();
        if (strength > 0.0) {
            float offset = 2.0f;
            double f1 = Math.min(strength, (double)FogProjectorScreen.camera_fog_strength_max) / (double)FogProjectorScreen.camera_fog_strength_max;
            float oldstart = type == FogRenderer.FogType.FOG_SKY ? 2.0f : farPlane * 0.75f;
            double f2 = RenderFogProjectors.fogScaleFormula(farPlane, f1);
            double f3 = RenderFogProjectors.fogScaleFormula(oldstart, f1);
            double fogStart = MathHelper.func_151237_a((double)f3, (double)1.0, (double)oldstart);
            double fogEnd = MathHelper.func_151237_a((double)f2, (double)4.0, (double)farPlane);
            if (type == FogRenderer.FogType.FOG_SKY) {
                fogStart = 0.0;
            }
            float fg = 0.7058824f;
            RenderSystem.enableFog();
            RenderSystem.fog((int)2918, (float)fg, (float)fg, (float)fg, (float)1.0f);
            RenderSystem.fogStart((float)((float)fogStart));
            RenderSystem.fogEnd((float)((float)fogEnd));
            RenderSystem.setupNvFogDistance();
            ret = true;
        }
        return ret;
    }

    public static double fogScaleFormula(float offset, double x) {
        return (x - 1.0) * (x - 1.0) * (x - 1.0) * (x - 1.0) * (double)offset;
    }
}

