/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.render.entity;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.util.ResourceLocation;
import stepsword.mahoutsukai.client.ClientHandler;
import stepsword.mahoutsukai.entity.LightningEntity;
import stepsword.mahoutsukai.render.CullWrappedRenderLayer;
import stepsword.mahoutsukai.render.MahoujinRenderType;
import stepsword.mahoutsukai.render.RenderUtils;

public class RenderLightningEntity
extends EntityRenderer<LightningEntity> {
    private static final ResourceLocation beam = new ResourceLocation("mahoutsukai:textures/block/white.png");

    public RenderLightningEntity(EntityRendererManager renderManager) {
        super(renderManager);
    }

    public ResourceLocation getTextureLocation(LightningEntity entity) {
        return AtlasTexture.field_110575_b;
    }

    public void render(LightningEntity entity, float eyaw, float partialTicks, MatrixStack matrix, IRenderTypeBuffer buffer, int packedLight) {
    }

    public static void renderLightning(LightningEntity entity, double x, double y, double z, MatrixStack matrix, float partialTicks) {
        float h;
        float pit;
        int i;
        matrix.func_227860_a_();
        matrix.func_227861_a_(x, y, z);
        float[] colors = entity.getColor();
        int lightmapX = 240;
        int lightmapY = 240;
        float w = entity.getBeamSize();
        float r2 = colors[0];
        float g2 = colors[1];
        float b2 = colors[2];
        float a2 = colors[3];
        float r = 1.0f;
        float g = 1.0f;
        float b = 1.0f;
        float a = 1.0f;
        r2 = 0.2f;
        g2 = 0.5f;
        b2 = 1.0f;
        a2 = 0.2f;
        RenderUtils.rotateQ(entity.yaw, 0.0f, 1.0f, 0.0f, matrix);
        RenderUtils.rotateQ(entity.pitch, 1.0f, 0.0f, 0.0f, matrix);
        if (entity.getZap()) {
            RenderUtils.rotateQ(-ClientHandler.clientTickCounter % 40L, 0.0f, 1.0f, 0.0f, matrix);
        } else {
            RenderUtils.rotateQ(ClientHandler.clientTickCounter % 40L, 0.0f, 1.0f, 0.0f, matrix);
        }
        IRenderTypeBuffer.Impl buf = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        float th = 0.0f;
        matrix.func_227860_a_();
        if (entity.getHasBall()) {
            CullWrappedRenderLayer sphere = new CullWrappedRenderLayer(MahoujinRenderType.createSphereRenderType(beam, 0));
            RenderUtils.renderSphere(matrix, (IRenderTypeBuffer)buf, w * 5.0f, 14, lightmapX, lightmapY, r, g, b, a, sphere);
            buf.func_228462_a_((RenderType)sphere);
        }
        matrix.func_227860_a_();
        for (i = 0; i < entity.segments; ++i) {
            CullWrappedRenderLayer ringType = new CullWrappedRenderLayer(MahoujinRenderType.createRunesRenderType(beam, 0));
            pit = entity.prevpitchs[i] + (entity.pitchs[i] - entity.prevpitchs[i]) * partialTicks;
            RenderUtils.rotateQ(pit, 1.0f, 0.0f, 0.0f, matrix);
            h = entity.prevreallengths[i] + (entity.reallengths[i] - entity.prevreallengths[i]) * partialTicks;
            RenderUtils.renderRing(matrix, (IRenderTypeBuffer)buf, 0.0, 90.0f, w, h, 20, 240, 240, r, g, b, a, ringType);
            buf.func_228462_a_((RenderType)ringType);
            matrix.func_227861_a_(0.0, (double)(-h), 0.0);
            th -= h;
            RenderUtils.rotateQ(-pit, 1.0f, 0.0f, 0.0f, matrix);
        }
        matrix.func_227865_b_();
        for (i = 0; i < entity.segments; ++i) {
            CullWrappedRenderLayer ringType2 = new CullWrappedRenderLayer(MahoujinRenderType.createRunesRenderType(beam, 1));
            pit = entity.prevpitchs[i] + (entity.pitchs[i] - entity.prevpitchs[i]) * partialTicks;
            RenderUtils.rotateQ(pit, 1.0f, 0.0f, 0.0f, matrix);
            h = entity.prevreallengths[i] + (entity.reallengths[i] - entity.prevreallengths[i]) * partialTicks;
            RenderUtils.renderRing(matrix, (IRenderTypeBuffer)buf, 0.0, 90.0f, w * 2.8f, h, 20, 240, 240, r2, g2, b2, a2, ringType2);
            buf.func_228462_a_((RenderType)ringType2);
            matrix.func_227861_a_(0.0, (double)(-h), 0.0);
            th -= h;
            RenderUtils.rotateQ(-pit, 1.0f, 0.0f, 0.0f, matrix);
        }
        matrix.func_227865_b_();
        if (entity.getHasBall()) {
            CullWrappedRenderLayer sphere = new CullWrappedRenderLayer(MahoujinRenderType.createSphereRenderType(beam, 0));
            RenderUtils.renderSphere(matrix, (IRenderTypeBuffer)buf, w * 6.9f, 14, lightmapX, lightmapY, r2, g2, b2, a2 / 2.0f, sphere);
            buf.func_228462_a_((RenderType)sphere);
        }
        matrix.func_227865_b_();
    }
}

