/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.potion;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.items.IItemHandler;
import stepsword.mahoutsukai.capability.kodoku.IKodokuMahou;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.handlers.ServerHandler;
import stepsword.mahoutsukai.item.kodoku.KodokuItem;
import stepsword.mahoutsukai.potion.ModEffects;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class MisfortunePotion
extends Effect {
    protected MisfortunePotion() {
        super(EffectType.NEUTRAL, ModEffects.getColorNumber(22, 22, 22));
        EffectUtil.effectIcon = new ResourceLocation("mahoutsukai", "textures/effects/misfortune.png");
    }

    public static void misfortuneLivingUpdate(LivingEntity living) {
        if (EffectUtil.hasBuff(living, ModEffects.MISFORTUNE) && !living.field_70170_p.field_72995_K && ServerHandler.tickCounter % 4L == 0L) {
            int level = EffectUtil.getBuffLevel(living, ModEffects.MISFORTUNE);
            if ((level -= MisfortunePotion.getMaxKodoku(living)) > 0) {
                ItemStack s;
                IItemHandler inv;
                double lightningchance = MTConfig.KODOKU_MISFORTUNE_LIGHTNING_CHANCE;
                double dropitemchance = MTConfig.KODOKU_MISFORTUNE_DROP_CHANCE;
                double aggrochance = MTConfig.KODOKU_MISFORTUNE_AGGRO_CHANCE;
                double tripchance = MTConfig.KODOKU_MISFORTUNE_TRIP_CHANCE;
                float aggro = living.func_70681_au().nextFloat();
                float trip = living.func_70681_au().nextFloat();
                float drop = living.func_70681_au().nextFloat();
                float lightning = living.func_70681_au().nextFloat();
                if ((double)aggro < aggrochance * (double)level) {
                    int range = 40;
                    AxisAlignedBB aabb = new AxisAlignedBB(living.func_226277_ct_() - (double)range, living.func_226278_cu_() - 10.0, living.func_226281_cx_() - (double)range, living.func_226277_ct_() + (double)range, living.func_226278_cu_() + 10.0, living.func_226281_cx_() + (double)range);
                    List lst = living.field_70170_p.func_217357_a(MobEntity.class, aabb);
                    if (lst.size() > 0) {
                        ((MobEntity)lst.get(living.func_70681_au().nextInt(lst.size()))).func_70604_c(living);
                    }
                }
                if ((double)drop < dropitemchance * (double)level && (inv = Utils.getInventory(living)) != null && inv.getSlots() > 0 && Utils.getInventory(s = inv.getStackInSlot(living.func_70681_au().nextInt(inv.getSlots()))) == null) {
                    living.func_199702_a((IItemProvider)s.func_77973_b(), 1);
                    s.func_190918_g(1);
                }
                if ((double)trip < tripchance * (double)level) {
                    Vector3d motion = living.func_213322_ci();
                    double motionX = motion.field_72450_a;
                    double motionY = motion.field_72448_b;
                    double motionZ = motion.field_72449_c;
                    living.field_70133_I = true;
                    living.func_213293_j(motionX += living.func_70040_Z().field_72450_a * 2.0, motionY, motionZ += living.func_70040_Z().field_72449_c * 2.0);
                }
                if ((double)lightning < lightningchance * (double)level) {
                    LightningBoltEntity lightningb = (LightningBoltEntity)EntityType.field_200728_aG.func_200721_a(living.field_70170_p);
                    lightningb.func_233576_c_(new Vector3d(living.func_226277_ct_(), living.func_226278_cu_(), living.func_226281_cx_()));
                    lightningb.func_233623_a_(false);
                    ((ServerWorld)living.field_70170_p).func_217376_c((Entity)lightningb);
                }
            }
        }
    }

    public static void misfortuneBreakEvent(BlockEvent.BreakEvent event) {
        if (EffectUtil.hasBuff((LivingEntity)event.getPlayer(), ModEffects.MISFORTUNE) && !event.getPlayer().field_70170_p.field_72995_K) {
            int level = EffectUtil.getBuffLevel((LivingEntity)event.getPlayer(), ModEffects.MISFORTUNE) / MTConfig.KODOKU_TOOL_BREAK_DIVISOR;
            event.getPlayer().func_184586_b(Hand.MAIN_HAND).func_222118_a(level, (LivingEntity)event.getPlayer(), a -> {});
        }
    }

    public static void misfortuneLootEvent(LivingDropsEvent event) {
        Entity base = event.getSource().func_76346_g();
        if (base instanceof LivingEntity && !base.field_70170_p.field_72995_K && EffectUtil.hasBuff((LivingEntity)base, ModEffects.MISFORTUNE)) {
            int level = EffectUtil.getBuffLevel((LivingEntity)base, ModEffects.MISFORTUNE) / MTConfig.KODOKU_LOOT_DIVISOR;
            for (int i = 0; i < level; ++i) {
                if (event.getDrops().size() <= 0) continue;
                int ind = ((LivingEntity)base).func_70681_au().nextInt(event.getDrops().size());
                event.getDrops().remove(ind);
            }
        }
    }

    public static int getMaxKodoku(LivingEntity living) {
        IItemHandler inventory = Utils.getInventory(living);
        int maxkodoku = 0;
        if (inventory != null) {
            for (int i = 0; i < inventory.getSlots(); ++i) {
                IKodokuMahou mahou;
                ItemStack s = inventory.getStackInSlot(i);
                if (s.func_190926_b() || !(s.func_77973_b() instanceof KodokuItem) || (mahou = Utils.getKodokuMahou(s)) == null || mahou.getKodoku() <= maxkodoku) continue;
                maxkodoku = mahou.getKodoku();
            }
        }
        return maxkodoku;
    }
}

