/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.effects.familiar;

import java.util.HashMap;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.CreeperSwellGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import stepsword.mahoutsukai.effects.familiar.SummonFamiliarSpellEffect;
import stepsword.mahoutsukai.entity.FamiliarEntity;
import stepsword.mahoutsukai.potion.ModEffects;
import stepsword.mahoutsukai.util.EffectUtil;

public class FamiliarsGardenEffect {
    public static boolean familiarGarden(PlayerEntity caster) {
        if (!caster.field_70170_p.field_72995_K) {
            FamiliarsGardenEffect.garden(caster);
        }
        return true;
    }

    public static boolean garden(PlayerEntity caster) {
        FamiliarEntity familiar;
        HashMap<UUID, FamiliarEntity> map;
        if (!caster.field_70170_p.field_72995_K && (map = SummonFamiliarSpellEffect.familiarMap).containsKey(caster.func_110124_au()) && (familiar = map.get(caster.func_110124_au())) != null && familiar.func_70089_S()) {
            ChunkPos chunk = new ChunkPos(familiar.func_233580_cy_());
            ServerWorld ws = (ServerWorld)caster.field_70170_p;
            if (ws.func_72863_F().func_217205_a(chunk.field_77276_a, chunk.field_77275_b, true) != null) {
                familiar.activateGarden();
                return true;
            }
            return false;
        }
        return false;
    }

    public static void familiarsGardenLivingUpdate(LivingEntity target) {
        if (EffectUtil.hasBuff(target, ModEffects.PEACEFUL_GARDEN)) {
            FamiliarsGardenEffect.garden(target);
        }
    }

    public static void garden(LivingEntity target) {
        if (target instanceof MobEntity) {
            ((MobEntity)target).func_70624_b(null);
            ((MobEntity)target).func_70604_c(null);
            ((MobEntity)target).field_70714_bg.func_220888_c().forEach(goal -> {
                if (goal.func_220772_j() instanceof NearestAttackableTargetGoal) {
                    goal.func_220772_j().func_75251_c();
                }
                if (goal.func_220772_j() instanceof CreeperSwellGoal) {
                    goal.func_220772_j().func_75251_c();
                }
                if (goal.func_220772_j().getClass().toString().toLowerCase().contains("attack")) {
                    goal.func_220772_j().func_75251_c();
                }
            });
        }
    }

    public static boolean familiarsGardenAttackEntity(Entity target, PlayerEntity player) {
        boolean ret = false;
        if (target instanceof LivingEntity && (EffectUtil.hasBuff((LivingEntity)target, ModEffects.PEACEFUL_GARDEN) || EffectUtil.hasBuff((LivingEntity)player, ModEffects.PEACEFUL_GARDEN))) {
            ret = true;
        }
        return ret;
    }

    public static boolean familiarsGardenExplosion(LivingEntity e) {
        boolean ret = false;
        if (e != null && EffectUtil.hasBuff(e, ModEffects.PEACEFUL_GARDEN)) {
            ret = true;
        }
        return ret;
    }

    public static boolean familiarsGardenLivingDamage(LivingDamageEvent event) {
        boolean ret = false;
        DamageSource src = event.getSource();
        if (src != null) {
            Entity attacker = src.func_76346_g();
            LivingEntity target = event.getEntityLiving();
            if (attacker instanceof LivingEntity && EffectUtil.hasBuff((LivingEntity)attacker, ModEffects.PEACEFUL_GARDEN)) {
                ret = true;
            }
            if (target != null && EffectUtil.hasBuff(target, ModEffects.PEACEFUL_GARDEN)) {
                ret = true;
            }
        }
        return ret;
    }
}

