/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.libjf.config.impl.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.LongArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import io.gitlab.jfronny.commons.throwable.ThrowingRunnable;
import io.gitlab.jfronny.commons.throwable.ThrowingSupplier;
import io.gitlab.jfronny.libjf.config.api.v1.ConfigCategory;
import io.gitlab.jfronny.libjf.config.api.v1.ConfigHolder;
import io.gitlab.jfronny.libjf.config.api.v1.EntryInfo;
import io.gitlab.jfronny.libjf.config.api.v1.type.Type;
import java.util.function.Consumer;
import java.util.function.Function;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;

public class JfConfigCommand
implements ModInitializer {
    private final DynamicCommandExceptionType eType = new DynamicCommandExceptionType(o -> {
        if (o instanceof Throwable) {
            Throwable throwable = (Throwable)o;
            return class_2561.method_43470((String)("Could not execute command: " + throwable.getMessage()));
        }
        return class_2561.method_43470((String)"Could not execute command");
    });

    public void onInitialize() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> {
            LiteralArgumentBuilder c_libjf = class_2170.method_9247((String)"libjf");
            LiteralArgumentBuilder c_config = (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"config").requires(serverCommandSource -> serverCommandSource.method_9259(4))).executes(context -> {
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"[libjf-config-v1] Loaded configs for:"), false);
                ConfigHolder.getInstance().getRegistered().forEach((s, config) -> ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("- " + s)), false));
                return 1;
            });
            LiteralArgumentBuilder c_reload = (LiteralArgumentBuilder)class_2170.method_9247((String)"reload").executes(context -> {
                ConfigHolder.getInstance().getRegistered().forEach((mod, config) -> config.load());
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"[libjf-config-v1] Reloaded configs"), true);
                return 1;
            });
            LiteralArgumentBuilder c_reset = (LiteralArgumentBuilder)class_2170.method_9247((String)"reset").executes(context -> {
                ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"[libjf-config-v1] Please specify a config to reset"));
                return 1;
            });
            ConfigHolder.getInstance().getRegistered().forEach((id, config) -> {
                c_reload.then(class_2170.method_9247((String)id).executes(context -> {
                    config.load();
                    ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("[libjf-config-v1] Reloaded config for " + id)), true);
                    return 1;
                }));
                this.registerEntries((ConfigCategory)config, (String)id, (LiteralArgumentBuilder<class_2168>)c_config, (LiteralArgumentBuilder<class_2168>)c_reset, cns -> {
                    LiteralArgumentBuilder c_instance = class_2170.method_9247((String)id);
                    cns.accept(c_instance);
                    return c_instance;
                });
            });
            dispatcher.register((LiteralArgumentBuilder)c_libjf.then(((LiteralArgumentBuilder)c_config.then((ArgumentBuilder)c_reload)).then((ArgumentBuilder)c_reset)));
        });
    }

    private void registerEntries(ConfigCategory config, String subpath, LiteralArgumentBuilder<class_2168> c_config, LiteralArgumentBuilder<class_2168> c_reset, Function<Consumer<LiteralArgumentBuilder<class_2168>>, LiteralArgumentBuilder<class_2168>> pathGen) {
        c_config.then((ArgumentBuilder)pathGen.apply(cns -> {
            cns.executes(context -> {
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("[libjf-config-v1] " + subpath + " is a category")), false);
                return 1;
            });
            for (EntryInfo entry : config.getEntries()) {
                this.registerEntry(config, subpath, (LiteralArgumentBuilder<class_2168>)cns, entry);
            }
        }));
        c_reset.then((ArgumentBuilder)pathGen.apply(cns -> {
            cns.executes(context -> {
                config.reset();
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("[libjf-config-v1] Reset config for " + subpath)), true);
                return 1;
            });
            config.getPresets().forEach((id2, preset) -> cns.then(class_2170.method_9247((String)id2).executes(context -> {
                preset.run();
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("[libjf-config-v1] Loaded preset " + id2 + " for " + subpath)), true);
                return 1;
            })));
        }));
        config.getCategories().forEach((id2, cfg) -> this.registerEntries((ConfigCategory)cfg, cfg.getCategoryPath(), c_config, c_reset, cns -> (LiteralArgumentBuilder)pathGen.apply(cns1 -> {
            LiteralArgumentBuilder c_instance2 = class_2170.method_9247((String)id2);
            cns.accept(c_instance2);
            cns1.then((ArgumentBuilder)c_instance2);
        })));
    }

    private <T> void registerEntry(ConfigCategory config, String subpath, LiteralArgumentBuilder<class_2168> cns, EntryInfo<T> entry) {
        LiteralArgumentBuilder c_entry = (LiteralArgumentBuilder)class_2170.method_9247((String)entry.getName()).executes(context -> {
            String msg = "[libjf-config-v1] The value of " + subpath + "." + entry.getName() + " is " + this.tryRun(() -> ((EntryInfo)entry).getValue());
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)msg), false);
            return 1;
        });
        ArgumentType<?> type = this.getType(entry);
        if (type != null) {
            c_entry.then(class_2170.method_9244((String)"value", type).executes(context -> {
                Object value = context.getArgument("value", (Class)entry.getValueType().asClass());
                this.tryRun(() -> {
                    entry.setValue(value);
                    config.getRoot().write();
                });
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("[libjf-config-v1] Set " + subpath + "." + entry.getName() + " to " + value)), true);
                return 1;
            }));
        } else if (entry.getValueType().isEnum()) {
            for (Object enumConstant : ((Type.TEnum)entry.getValueType()).options()) {
                c_entry.then(class_2170.method_9247((String)enumConstant.toString()).executes(context -> {
                    this.tryRun(() -> {
                        entry.setValue(enumConstant);
                        config.getRoot().write();
                    });
                    ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("[libjf-config-v1] Set " + subpath + "." + entry.getName() + " to " + enumConstant)), true);
                    return 1;
                }));
            }
        }
        cns.then((ArgumentBuilder)c_entry);
    }

    private <T> ArgumentType<?> getType(EntryInfo<T> info) {
        Type type = info.getValueType();
        if (type.isInt()) {
            return IntegerArgumentType.integer((int)((int)info.getMinValue()), (int)((int)info.getMaxValue()));
        }
        if (type.isLong()) {
            return LongArgumentType.longArg((long)((long)info.getMinValue()), (long)((long)info.getMaxValue()));
        }
        if (type.isFloat()) {
            return FloatArgumentType.floatArg((float)((float)info.getMinValue()), (float)((float)info.getMaxValue()));
        }
        if (type.isDouble()) {
            return DoubleArgumentType.doubleArg((double)info.getMinValue(), (double)info.getMaxValue());
        }
        if (type.isString()) {
            return StringArgumentType.greedyString();
        }
        if (type.isBool()) {
            return BoolArgumentType.bool();
        }
        return null;
    }

    private <T> T tryRun(ThrowingSupplier<T, ?> supplier) throws CommandSyntaxException {
        return (T)supplier.orThrow(arg_0 -> ((DynamicCommandExceptionType)this.eType).create(arg_0)).get();
    }

    private void tryRun(ThrowingRunnable<?> supplier) throws CommandSyntaxException {
        supplier.orThrow(arg_0 -> ((DynamicCommandExceptionType)this.eType).create(arg_0)).run();
    }
}

