/*
 * Decompiled with CFR 0.152.
 */
package io.github.fablabsmc.fablabs.impl.fiber.annotation.magic;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import javax.annotation.Nullable;

public final class TypeMagic {
    public static Object box(Object t) {
        Class<?> wc;
        Class<?> c;
        if (t.getClass().isArray() && (c = t.getClass().getComponentType()) != (wc = TypeMagic.wrapPrimitive(c))) {
            Object arr = Array.newInstance(wc, Array.getLength(t));
            for (int i = 0; i < Array.getLength(t); ++i) {
                Array.set(arr, i, Array.get(t, i));
            }
            return arr;
        }
        return t;
    }

    public static Object unbox(Object t) {
        Class<?> c;
        Class<?> wc;
        if (t.getClass().isArray() && (wc = t.getClass().getComponentType()) != (c = TypeMagic.unwrapPrimitive(wc))) {
            Object arr = Array.newInstance(c, Array.getLength(t));
            for (int i = 0; i < Array.getLength(t); ++i) {
                Array.set(arr, i, Array.get(t, i));
            }
            return arr;
        }
        return t;
    }

    public static <T> Class<T> wrapPrimitive(Class<T> type) {
        if (type.equals(Boolean.TYPE)) {
            return Boolean.class;
        }
        if (type.equals(Byte.TYPE)) {
            return Byte.class;
        }
        if (type.equals(Character.TYPE)) {
            return Character.class;
        }
        if (type.equals(Short.TYPE)) {
            return Short.class;
        }
        if (type.equals(Integer.TYPE)) {
            return Integer.class;
        }
        if (type.equals(Double.TYPE)) {
            return Double.class;
        }
        if (type.equals(Float.TYPE)) {
            return Float.class;
        }
        if (type.equals(Long.TYPE)) {
            return Long.class;
        }
        return type;
    }

    public static <T> Class<T> unwrapPrimitive(Class<T> type) {
        if (type.equals(Boolean.class)) {
            return Boolean.TYPE;
        }
        if (type.equals(Byte.class)) {
            return Byte.TYPE;
        }
        if (type.equals(Character.class)) {
            return Character.TYPE;
        }
        if (type.equals(Short.class)) {
            return Short.TYPE;
        }
        if (type.equals(Integer.class)) {
            return Integer.TYPE;
        }
        if (type.equals(Double.class)) {
            return Double.TYPE;
        }
        if (type.equals(Float.class)) {
            return Float.TYPE;
        }
        if (type.equals(Long.class)) {
            return Long.TYPE;
        }
        return type;
    }

    @Nullable
    public static Class<?> classForType(Type t) {
        if (t instanceof Class) {
            return (Class)t;
        }
        if (t instanceof ParameterizedType) {
            Type subtype = ((ParameterizedType)t).getRawType();
            if (subtype instanceof Class) {
                return (Class)subtype;
            }
            String className = t.getTypeName();
            int typeParamStart = className.indexOf(60);
            if (typeParamStart >= 0) {
                className = className.substring(0, typeParamStart);
            }
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (t instanceof WildcardType) {
            Type[] upperBounds = ((WildcardType)t).getUpperBounds();
            if (upperBounds.length == 0) {
                return Object.class;
            }
            return TypeMagic.classForType(upperBounds[0]);
        }
        if (t instanceof TypeVariable) {
            return Object.class;
        }
        if (t instanceof GenericArrayType) {
            GenericArrayType arrayType = (GenericArrayType)t;
            Class<?> componentClass = TypeMagic.classForType(arrayType.getGenericComponentType());
            try {
                assert (componentClass != null);
                return Class.forName("[L" + componentClass.getCanonicalName() + ";");
            }
            catch (ClassNotFoundException ex2) {
                return Object[].class;
            }
        }
        return null;
    }
}

