/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.sgui.api.gui;

import eu.pb4.sgui.api.gui.GuiInterface;
import eu.pb4.sgui.virtual.FakeScreenHandler;
import eu.pb4.sgui.virtual.sign.VirtualSignBlockEntity;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1767;
import net.minecraft.class_1922;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2626;
import net.minecraft.class_2645;
import net.minecraft.class_2680;
import net.minecraft.class_2693;
import net.minecraft.class_3222;
import net.minecraft.class_3481;
import net.minecraft.class_3917;
import org.jetbrains.annotations.ApiStatus;

public class SignGui
implements GuiInterface {
    protected final VirtualSignBlockEntity signEntity;
    protected class_2680 type = class_2246.field_10121.method_9564();
    protected boolean autoUpdate = true;
    protected List<Integer> sendLineUpdate = new ArrayList<Integer>(4);
    protected final class_3222 player;
    protected boolean open = false;
    protected boolean reOpen = false;
    protected FakeScreenHandler screenHandler;
    private final class_2561[] texts = new class_2561[4];

    public SignGui(class_3222 player) {
        this.player = player;
        this.signEntity = new VirtualSignBlockEntity(new class_2338(player.method_24515().method_10263(), Math.min(player.method_37908().method_31600() - 1, player.method_24515().method_10264() + 5), player.method_24515().method_10260()), class_2246.field_10121.method_9564());
    }

    public void setLine(int line, class_2561 text) {
        this.signEntity.method_49841(signText -> signText.method_49857(line, text), true);
        this.sendLineUpdate.add(line);
        this.texts[line] = text;
        if (this.open & this.autoUpdate) {
            this.updateSign();
        }
    }

    public class_2561 getLine(int line) {
        return this.texts[line];
    }

    public void setColor(class_1767 color) {
        this.signEntity.method_49841(signText -> signText.method_49862(color), true);
        if (this.open && this.autoUpdate) {
            this.updateSign();
        }
    }

    public void setSignType(class_2248 type) {
        if (!type.method_40142().method_40220(class_3481.field_15500)) {
            throw new IllegalArgumentException("The type must be a sign");
        }
        this.type = type.method_9564();
        if (this.open && this.autoUpdate) {
            this.updateSign();
        }
    }

    public void updateSign() {
        if (this.player.field_7512 == this.screenHandler) {
            this.reOpen = true;
            this.player.field_13987.method_14364((class_2596)new class_2645(this.screenHandler.field_7763));
        } else {
            this.open();
        }
    }

    @Override
    public class_3222 getPlayer() {
        return this.player;
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public boolean open() {
        this.reOpen = true;
        if (this.player.field_7512 != this.player.field_7498 && this.player.field_7512 != this.screenHandler) {
            this.player.method_7346();
        }
        if (this.screenHandler == null) {
            this.screenHandler = new FakeScreenHandler(this);
        }
        this.player.field_7512 = this.screenHandler;
        this.player.field_13987.method_14364((class_2596)new class_2626(this.signEntity.method_11016(), this.type));
        this.player.field_13987.method_14364((class_2596)this.signEntity.method_38249());
        this.player.field_13987.method_14364((class_2596)new class_2693(this.signEntity.method_11016(), true));
        this.reOpen = false;
        this.open = true;
        return true;
    }

    @Override
    public void close(boolean alreadyClosed) {
        if (this.open && !this.reOpen) {
            this.open = false;
            this.reOpen = false;
            this.player.field_13987.method_14364((class_2596)new class_2626((class_1922)this.player.method_51469(), this.signEntity.method_11016()));
            if (alreadyClosed && this.player.field_7512 == this.screenHandler) {
                this.player.method_14247();
            } else {
                this.player.method_7346();
            }
            this.onClose();
        } else {
            this.reOpen = false;
            this.open();
        }
    }

    @Override
    public boolean getAutoUpdate() {
        return this.autoUpdate;
    }

    @Override
    public void setAutoUpdate(boolean value) {
        this.autoUpdate = value;
    }

    @ApiStatus.Internal
    public void setLineInternal(int line, class_2561 text) {
        if (this.reOpen && this.sendLineUpdate.contains(line)) {
            this.sendLineUpdate.remove((Object)line);
        } else {
            this.signEntity.method_49853().method_49857(line, text);
            this.texts[line] = text;
        }
    }

    @Override
    @Deprecated
    public void setTitle(class_2561 title) {
    }

    @Override
    @Deprecated
    public class_2561 getTitle() {
        return null;
    }

    @Override
    @Deprecated
    public class_3917<?> getType() {
        return null;
    }

    @Override
    @Deprecated
    public int getSyncId() {
        return -1;
    }
}

