/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.libjf.gson;

import io.gitlab.jfronny.gson.JsonArray;
import io.gitlab.jfronny.gson.JsonElement;
import io.gitlab.jfronny.gson.JsonNull;
import io.gitlab.jfronny.gson.JsonObject;
import io.gitlab.jfronny.gson.JsonPrimitive;
import java.util.Map;
import net.fabricmc.loader.api.metadata.CustomValue;

public class FabricLoaderGsonGenerator {
    public static JsonElement toGson(CustomValue customValue) {
        if (customValue == null) {
            return null;
        }
        return switch (customValue.getType()) {
            default -> throw new IncompatibleClassChangeError();
            case CustomValue.CvType.OBJECT -> {
                JsonObject jo = new JsonObject();
                for (Map.Entry value : customValue.getAsObject()) {
                    jo.add((String)value.getKey(), FabricLoaderGsonGenerator.toGson((CustomValue)value.getValue()));
                }
                yield jo;
            }
            case CustomValue.CvType.ARRAY -> {
                JsonArray jo = new JsonArray();
                for (CustomValue value : customValue.getAsArray()) {
                    jo.add(FabricLoaderGsonGenerator.toGson(value));
                }
                yield jo;
            }
            case CustomValue.CvType.STRING -> new JsonPrimitive(customValue.getAsString());
            case CustomValue.CvType.NUMBER -> new JsonPrimitive(customValue.getAsNumber());
            case CustomValue.CvType.BOOLEAN -> new JsonPrimitive(customValue.getAsBoolean());
            case CustomValue.CvType.NULL -> JsonNull.INSTANCE;
        };
    }
}

