/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.commons.tuple;

import java.util.Objects;
import java.util.function.Function;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record Triple<T1, T2, T3>(@Nullable T1 val1, @Nullable T2 val2, @Nullable T3 val3) {
    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public static <T1, T2, T3> Triple<T1, T2, T3> of(@Nullable T1 val1, @Nullable T2 val2, @Nullable T3 val3) {
        return new Triple<T1, T2, T3>(val1, val2, val3);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public <T> Triple<T, T2, T3> map1(@NotNull Function<T1, T> mapper) {
        return new Triple<T, T2, T3>(Objects.requireNonNull(mapper).apply(this.val1), this.val2, this.val3);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public <T> Triple<T1, T, T3> map2(@NotNull Function<T2, T> mapper) {
        return new Triple<T1, T, T3>(this.val1, Objects.requireNonNull(mapper).apply(this.val2), this.val3);
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public <T> Triple<T1, T2, T> map3(@NotNull Function<T3, T> mapper) {
        return new Triple<T1, T2, T>(this.val1, this.val2, Objects.requireNonNull(mapper).apply(this.val3));
    }

    @Contract(value="-> new", pure=true)
    @NotNull
    public Triple<T2, T3, T1> lShift() {
        return new Triple<T2, T3, T1>(this.val2, this.val3, this.val1);
    }

    @Contract(value="-> new", pure=true)
    @NotNull
    public Triple<T3, T1, T2> rShift() {
        return new Triple<T3, T1, T2>(this.val3, this.val1, this.val2);
    }

    @Contract(value="-> new", pure=true)
    @NotNull
    public Triple<T2, T1, T3> swapL() {
        return new Triple<T2, T1, T3>(this.val2, this.val1, this.val3);
    }

    @Contract(value="-> new", pure=true)
    @NotNull
    public Triple<T1, T3, T2> swapR() {
        return new Triple<T1, T3, T2>(this.val1, this.val3, this.val2);
    }

    @Contract(value="-> new", pure=true)
    @NotNull
    public Triple<T3, T2, T1> reverse() {
        return new Triple<T3, T2, T1>(this.val3, this.val2, this.val1);
    }
}

