/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.commons.tuple;

import io.gitlab.jfronny.commons.throwable.ThrowingPredicate;
import io.gitlab.jfronny.commons.throwable.ThrowingSupplier;
import java.util.Objects;
import java.util.function.Function;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record Single<T1>(@Nullable T1 val) {
    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static <T1> Single<T1> of(@Nullable T1 val) {
        return new Single<T1>(val);
    }

    @Contract(pure=true)
    public boolean isNull() {
        return this.val == null;
    }

    @Contract(pure=true)
    public boolean isPresent() {
        return this.val != null;
    }

    @Contract(value="-> new", pure=true)
    @NotNull
    public ThrowingPredicate<T1, RuntimeException> asEqualsPredicate() {
        return this.val == null ? Objects::isNull : this.val::equals;
    }

    @Contract(value="-> new", pure=true)
    @NotNull
    public ThrowingPredicate<T1, RuntimeException> asInstanceEqualsPredicate() {
        return v -> v == this.val;
    }

    @Contract(value="-> new", pure=true)
    @NotNull
    public ThrowingSupplier<T1, RuntimeException> asSupplier() {
        return () -> this.val;
    }

    @Contract(value="_, -> new", pure=true)
    @NotNull
    public <T> Single<T> map(@NotNull Function<T1, T> mapper) {
        return new Single<T>(Objects.requireNonNull(mapper).apply(this.val));
    }

    @Contract(pure=true)
    @Nullable
    public T1 get() {
        return this.val;
    }
}

