/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.commons.throwable;

import io.gitlab.jfronny.commons.throwable.ThrowingConsumer;
import io.gitlab.jfronny.commons.throwable.ThrowingFunction;
import io.gitlab.jfronny.commons.throwable.ThrowingRunnable;
import io.gitlab.jfronny.commons.throwable.Try;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

@FunctionalInterface
public interface ThrowingSupplier<T, TEx extends Throwable> {
    public T get() throws TEx;

    @Contract(value="_ -> new", pure=true)
    @ApiStatus.NonExtendable
    @NotNull
    default public <V> ThrowingSupplier<V, TEx> andThen(@NotNull ThrowingFunction<? super T, ? extends V, ? extends TEx> after) {
        Objects.requireNonNull(after);
        return () -> after.apply((T)this.get());
    }

    @Contract(value="_ -> new", pure=true)
    @ApiStatus.NonExtendable
    @NotNull
    default public ThrowingRunnable<TEx> andThen(@NotNull ThrowingConsumer<? super T, ? extends TEx> after) {
        Objects.requireNonNull(after);
        return () -> after.accept((T)this.get());
    }

    @Contract(value="_ -> new", pure=true)
    @ApiStatus.NonExtendable
    @NotNull
    default public Supplier<T> addHandler(@NotNull Function<Throwable, ? extends T> handler) {
        Objects.requireNonNull(handler);
        return () -> {
            try {
                return this.get();
            }
            catch (Throwable e) {
                return handler.apply(e);
            }
        };
    }

    @Contract(value="_, _ -> new", pure=true)
    @ApiStatus.NonExtendable
    @NotNull
    default public Supplier<T> addHandler(@NotNull Class<TEx> exception, @NotNull Function<TEx, ? extends T> handler) {
        Objects.requireNonNull(exception);
        Objects.requireNonNull(handler);
        return () -> {
            try {
                return this.get();
            }
            catch (Throwable e) {
                if (exception.isAssignableFrom(e.getClass())) {
                    return handler.apply(e);
                }
                throw Try.runtimeException(e);
            }
        };
    }

    @Contract(value="-> new", pure=true)
    @ApiStatus.NonExtendable
    @NotNull
    default public Supplier<T> orThrow() {
        return this.orThrow(Try::runtimeException)::get;
    }

    @Contract(value="_ -> new", pure=true)
    @ApiStatus.NonExtendable
    @NotNull
    default public <TEx1 extends Throwable> ThrowingSupplier<T, TEx1> orThrow(@NotNull Function<Throwable, TEx1> generator) {
        Objects.requireNonNull(generator);
        return () -> {
            try {
                return this.get();
            }
            catch (Throwable e) {
                throw (Throwable)generator.apply(e);
            }
        };
    }
}

