/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.commons.throwable;

import io.gitlab.jfronny.commons.throwable.ThrowingPredicate;
import io.gitlab.jfronny.commons.throwable.Try;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

@FunctionalInterface
public interface ThrowingBooleanSupplier<TEx extends Throwable> {
    public boolean get() throws TEx;

    @Contract(value="_ -> new", pure=true)
    @ApiStatus.NonExtendable
    @NotNull
    default public <T> ThrowingPredicate<T, TEx> and(@NotNull ThrowingPredicate<? super T, ? extends TEx> other) {
        Objects.requireNonNull(other);
        return t -> this.get() && other.test(t);
    }

    @Contract(value="_ -> new", pure=true)
    @ApiStatus.NonExtendable
    @NotNull
    default public ThrowingBooleanSupplier<TEx> and(@NotNull ThrowingBooleanSupplier<? extends TEx> other) {
        Objects.requireNonNull(other);
        return () -> this.get() && other.get();
    }

    @Contract(value="_ -> new", pure=true)
    @ApiStatus.NonExtendable
    @NotNull
    default public <T> ThrowingPredicate<T, TEx> or(@NotNull ThrowingPredicate<? super T, ? extends TEx> other) {
        Objects.requireNonNull(other);
        return t -> this.get() || other.test(t);
    }

    @Contract(value="_ -> new", pure=true)
    @ApiStatus.NonExtendable
    @NotNull
    default public ThrowingBooleanSupplier<TEx> or(@NotNull ThrowingBooleanSupplier<? extends TEx> other) {
        Objects.requireNonNull(other);
        return () -> this.get() || other.get();
    }

    @Contract(value="_ -> new", pure=true)
    @ApiStatus.NonExtendable
    @NotNull
    default public <T> ThrowingPredicate<T, TEx> xor(@NotNull ThrowingPredicate<? super T, ? extends TEx> other) {
        Objects.requireNonNull(other);
        return t -> this.get() ^ other.test(t);
    }

    @Contract(value="_ -> new", pure=true)
    @ApiStatus.NonExtendable
    @NotNull
    default public ThrowingBooleanSupplier<TEx> xor(@NotNull ThrowingBooleanSupplier<? extends TEx> other) {
        Objects.requireNonNull(other);
        return () -> this.get() ^ other.get();
    }

    @Contract(value="-> new", pure=true)
    @ApiStatus.NonExtendable
    @NotNull
    default public ThrowingBooleanSupplier<TEx> negate() {
        return () -> !this.get();
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static <TEx extends Throwable> ThrowingBooleanSupplier<TEx> not(@NotNull ThrowingBooleanSupplier<TEx> target) {
        return Objects.requireNonNull(target).negate();
    }

    @Contract(value="_ -> new", pure=true)
    @ApiStatus.NonExtendable
    @NotNull
    default public BooleanSupplier addHandler(@NotNull Predicate<Throwable> handler) {
        Objects.requireNonNull(handler);
        return () -> {
            try {
                return this.get();
            }
            catch (Throwable e) {
                return handler.test(e);
            }
        };
    }

    @Contract(value="_, _ -> new", pure=true)
    @ApiStatus.NonExtendable
    @NotNull
    default public BooleanSupplier addHandler(@NotNull Class<TEx> exception, @NotNull Predicate<TEx> handler) {
        Objects.requireNonNull(exception);
        Objects.requireNonNull(handler);
        return () -> {
            try {
                return this.get();
            }
            catch (Throwable e) {
                if (exception.isAssignableFrom(e.getClass())) {
                    return handler.test(e);
                }
                throw Try.runtimeException(e);
            }
        };
    }

    @Contract(value="-> new", pure=true)
    @ApiStatus.NonExtendable
    @NotNull
    default public BooleanSupplier orThrow() {
        return this.orThrow(Try::runtimeException)::get;
    }

    @Contract(value="_ -> new", pure=true)
    @ApiStatus.NonExtendable
    @NotNull
    default public <TEx1 extends Throwable> ThrowingBooleanSupplier<TEx1> orThrow(@NotNull Function<Throwable, TEx1> generator) {
        Objects.requireNonNull(generator);
        return () -> {
            try {
                return this.get();
            }
            catch (Throwable e) {
                throw (Throwable)generator.apply(e);
            }
        };
    }
}

