/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.commons.throwable;

import io.gitlab.jfronny.commons.throwable.ThrowingBiConsumer;
import io.gitlab.jfronny.commons.throwable.ThrowingConsumer;
import io.gitlab.jfronny.commons.throwable.ThrowingFunction;
import io.gitlab.jfronny.commons.throwable.Try;
import io.gitlab.jfronny.commons.tuple.Tuple;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

@FunctionalInterface
public interface ThrowingBiFunction<T, U, R, TEx extends Throwable> {
    public R apply(T var1, U var2) throws TEx;

    @Contract(value="-> new", pure=true)
    @ApiStatus.NonExtendable
    @NotNull
    default public ThrowingFunction<Tuple<T, U>, R, TEx> fromTuple() {
        return t -> this.apply(t.left(), t.right());
    }

    @Contract(value="_, _ -> new", pure=true)
    @ApiStatus.NonExtendable
    @NotNull
    default public <V> ThrowingFunction<V, R, TEx> compose(@NotNull ThrowingFunction<? super V, ? extends T, ? extends TEx> left, @NotNull ThrowingFunction<? super V, ? extends U, ? extends TEx> right) {
        Objects.requireNonNull(left);
        Objects.requireNonNull(right);
        return t -> this.apply(left.apply((Object)t), right.apply((Object)t));
    }

    @Contract(value="_, _ -> new", pure=true)
    @ApiStatus.NonExtendable
    @NotNull
    default public <V, W> ThrowingBiFunction<V, W, R, TEx> biCompose(@NotNull ThrowingFunction<? super V, ? extends T, ? extends TEx> left, @NotNull ThrowingFunction<? super W, ? extends U, ? extends TEx> right) {
        Objects.requireNonNull(left);
        Objects.requireNonNull(right);
        return (l, r) -> this.apply(left.apply((Object)l), right.apply((Object)r));
    }

    @Contract(value="_ -> new", pure=true)
    @ApiStatus.NonExtendable
    @NotNull
    default public <V> ThrowingBiFunction<V, U, R, TEx> composeLeft(@NotNull ThrowingFunction<? super V, ? extends T, ? extends TEx> before) {
        Objects.requireNonNull(before);
        return (l, r) -> this.apply(before.apply((Object)l), r);
    }

    @Contract(value="_ -> new", pure=true)
    @ApiStatus.NonExtendable
    @NotNull
    default public <V> ThrowingBiFunction<T, V, R, TEx> composeRight(@NotNull ThrowingFunction<? super V, ? extends U, ? extends TEx> before) {
        Objects.requireNonNull(before);
        return (l, r) -> this.apply(l, before.apply((Object)r));
    }

    @Contract(value="_ -> new", pure=true)
    @ApiStatus.NonExtendable
    @NotNull
    default public <V> ThrowingBiFunction<T, U, V, TEx> andThen(@NotNull ThrowingFunction<? super R, ? extends V, ? extends TEx> after) {
        Objects.requireNonNull(after);
        return (t, u) -> after.apply((R)this.apply(t, u));
    }

    @Contract(value="_ -> new", pure=true)
    @ApiStatus.NonExtendable
    @NotNull
    default public ThrowingBiConsumer<T, U, TEx> andThen(@NotNull ThrowingConsumer<? super R, ? extends TEx> after) {
        Objects.requireNonNull(after);
        return (t, u) -> after.accept((R)this.apply(t, u));
    }

    @Contract(value="_ -> new", pure=true)
    @ApiStatus.NonExtendable
    @NotNull
    default public BiFunction<T, U, R> addHandler(@NotNull Function<Throwable, ? extends R> handler) {
        Objects.requireNonNull(handler);
        return (t, u) -> {
            try {
                return this.apply(t, u);
            }
            catch (Throwable e) {
                return handler.apply(e);
            }
        };
    }

    @Contract(value="_, _ -> new", pure=true)
    @ApiStatus.NonExtendable
    @NotNull
    default public BiFunction<T, U, R> addHandler(@NotNull Class<TEx> exception, @NotNull Function<TEx, ? extends R> handler) {
        Objects.requireNonNull(exception);
        Objects.requireNonNull(handler);
        return (t, u) -> {
            try {
                return this.apply(t, u);
            }
            catch (Throwable e) {
                if (exception.isAssignableFrom(e.getClass())) {
                    return handler.apply(e);
                }
                throw Try.runtimeException(e);
            }
        };
    }

    @Contract(value="-> new", pure=true)
    @ApiStatus.NonExtendable
    @NotNull
    default public BiFunction<T, U, R> orThrow() {
        return this.orThrow(Try::runtimeException)::apply;
    }

    @Contract(value="_ -> new", pure=true)
    @ApiStatus.NonExtendable
    @NotNull
    default public <TEx1 extends Throwable> ThrowingBiFunction<T, U, R, TEx1> orThrow(@NotNull Function<Throwable, TEx1> generator) {
        Objects.requireNonNull(generator);
        return (t, u) -> {
            try {
                return this.apply(t, u);
            }
            catch (Throwable e) {
                throw (Throwable)generator.apply(e);
            }
        };
    }
}

