/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.commons.serialize.gson.api.v1;

import io.gitlab.jfronny.commons.ComparableVersion;
import io.gitlab.jfronny.commons.ref.WeakSet;
import io.gitlab.jfronny.commons.serialize.gson.api.v1.GsonHolders;
import io.gitlab.jfronny.commons.serialize.gson.impl.ComparableVersionAdapter;
import io.gitlab.jfronny.commons.serialize.gson.impl.GsonIgnoreExclusionStrategy;
import io.gitlab.jfronny.gson.Gson;
import io.gitlab.jfronny.gson.GsonBuilder;
import io.gitlab.jfronny.gson.TypeAdapterFactory;
import java.lang.reflect.Type;
import java.util.function.Consumer;

public class GsonHolder {
    private final GsonBuilder builder = new GsonBuilder().registerTypeAdapter((Type)((Object)ComparableVersion.class), new ComparableVersionAdapter()).excludeFieldsWithModifiers(128, 2).setExclusionStrategies(new GsonIgnoreExclusionStrategy()).setLenient();
    private boolean clean = false;
    private Gson gson;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GsonHolder() {
        WeakSet<GsonHolder> weakSet = GsonHolders.KNOWN_INSTANCES;
        synchronized (weakSet) {
            GsonHolders.KNOWN_INSTANCES.add(this);
            for (Consumer<GsonBuilder> modification : GsonHolders.KNOWN_MODIFICATIONS) {
                modification.accept(this.builder);
            }
        }
    }

    public Gson getGson() {
        if (!this.clean) {
            this.gson = this.builder.create();
            this.clean = true;
        }
        return this.gson;
    }

    public GsonHolder registerTypeAdapter(Type type, Object typeAdapter) {
        this.builder.registerTypeAdapter(type, typeAdapter);
        this.clean = false;
        return this;
    }

    public GsonHolder registerTypeAdapterFactory(TypeAdapterFactory factory) {
        this.builder.registerTypeAdapterFactory(factory);
        this.clean = false;
        return this;
    }

    public GsonHolder modifyBuilder(Consumer<GsonBuilder> func) {
        func.accept(this.builder);
        this.clean = false;
        return this;
    }
}

