/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.commons.log;

import io.gitlab.jfronny.commons.cache.FixedSizeSet;
import io.gitlab.jfronny.commons.log.Logger;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MemoryLogger
implements Logger,
Iterable<String> {
    private final String name;
    private final Set<String> lines;

    public MemoryLogger(String name) {
        this.name = name;
        this.lines = new LinkedHashSet<String>();
    }

    public MemoryLogger(String name, int size) {
        this.name = name;
        this.lines = new FixedSizeSet<String>(size);
    }

    @Override
    @Nullable
    public String getName() {
        return this.name;
    }

    @Override
    public void trace(String msg) {
        this.lines.add("[T] " + msg);
    }

    @Override
    public void debug(String msg) {
        this.lines.add("[D] " + msg);
    }

    @Override
    public void info(String msg) {
        this.lines.add("[I] " + msg);
    }

    @Override
    public void warn(String msg) {
        this.lines.add("[W] " + msg);
    }

    @Override
    public void error(String msg) {
        this.lines.add("[E] " + msg);
    }

    @Override
    @NotNull
    public Iterator<String> iterator() {
        return this.lines.iterator();
    }

    @Override
    public void forEach(Consumer<? super String> action) {
        this.lines.forEach(action);
    }

    @Override
    public Spliterator<String> spliterator() {
        return this.lines.spliterator();
    }
}

