/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.commons.log;

import io.gitlab.jfronny.commons.StringFormatter;
import io.gitlab.jfronny.commons.log.HotSwappingDelegateLogger;
import io.gitlab.jfronny.commons.log.Level;
import java.util.Objects;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Logger {
    public static Logger forName(@NotNull String name) {
        return HotSwappingDelegateLogger.forName(Objects.requireNonNull(name));
    }

    public static void registerFactory(@NotNull Function<String, Logger> factory) {
        HotSwappingDelegateLogger.updateStrategy(Objects.requireNonNull(factory));
    }

    public static void resetFactory() {
        HotSwappingDelegateLogger.resetStrategy();
    }

    public static void setMinimumLevel(@NotNull Level level) {
        HotSwappingDelegateLogger.updateMinimumLevel(level);
    }

    @Nullable
    public String getName();

    default public void trace(String msg) {
        this.debug(msg);
    }

    default public void trace(String format, Object arg) {
        this.trace(this.format(format, arg));
    }

    default public void trace(String format, Object ... args) {
        this.trace(this.format(format, args));
    }

    default public void trace(String msg, Throwable t) {
        this.trace(this.format(msg, t));
    }

    default public void debug(String msg) {
        this.info(msg);
    }

    default public void debug(String format, Object arg) {
        this.debug(this.format(format, arg));
    }

    default public void debug(String format, Object ... args) {
        this.debug(this.format(format, args));
    }

    default public void debug(String msg, Throwable t) {
        this.debug(this.format(msg, t));
    }

    public void info(String var1);

    default public void info(String format, Object arg) {
        this.info(this.format(format, arg));
    }

    default public void info(String format, Object ... args) {
        this.info(this.format(format, args));
    }

    default public void info(String msg, Throwable t) {
        this.info(this.format(msg, t));
    }

    default public void warn(String msg) {
        this.info(msg);
    }

    default public void warn(String format, Object arg) {
        this.warn(this.format(format, arg));
    }

    default public void warn(String format, Object ... args) {
        this.warn(this.format(format, args));
    }

    default public void warn(String msg, Throwable t) {
        this.warn(this.format(msg, t));
    }

    default public void error(String msg) {
        this.warn(msg);
    }

    default public void error(String format, Object arg) {
        this.error(this.format(format, arg));
    }

    default public void error(String format, Object ... args) {
        this.error(this.format(format, args));
    }

    default public void error(String msg, Throwable t) {
        this.error(this.format(msg, t));
    }

    default public String format(String format, Object arg) {
        return format.replaceFirst("\\{}", StringFormatter.toString(arg));
    }

    default public String format(String format, Object ... args) {
        if (args == null || format == null) {
            return format;
        }
        for (Object arg : args) {
            format = format.replaceFirst("\\{}", StringFormatter.toString(arg));
        }
        return format;
    }

    default public String format(String msg, Throwable t) {
        if (t == null) {
            return msg;
        }
        return msg + System.lineSeparator() + StringFormatter.toString(t);
    }
}

