/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.commons.log;

import io.gitlab.jfronny.commons.log.Level;
import io.gitlab.jfronny.commons.log.Logger;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class DelegateLogger
implements Logger {
    protected Logger delegate;
    protected Level minimumLevel = Level.TRACE;

    public DelegateLogger() {
        this(null);
    }

    public DelegateLogger(Logger delegate) {
        this.delegate = delegate;
    }

    @Override
    @Nullable
    public String getName() {
        return this.delegate.getName();
    }

    @Override
    public void trace(String msg) {
        if (this.minimumLevel.shouldOmit(Level.TRACE)) {
            return;
        }
        this.delegate.trace(msg);
    }

    @Override
    public void trace(String format, Object arg) {
        if (this.minimumLevel.shouldOmit(Level.TRACE)) {
            return;
        }
        this.delegate.trace(format, arg);
    }

    @Override
    public void trace(String format, Object ... args) {
        if (this.minimumLevel.shouldOmit(Level.TRACE)) {
            return;
        }
        this.delegate.trace(format, args);
    }

    @Override
    public void trace(String msg, Throwable t) {
        if (this.minimumLevel.shouldOmit(Level.TRACE)) {
            return;
        }
        this.delegate.trace(msg, t);
    }

    @Override
    public void debug(String msg) {
        if (this.minimumLevel.shouldOmit(Level.DEBUG)) {
            return;
        }
        this.delegate.debug(msg);
    }

    @Override
    public void debug(String format, Object arg) {
        if (this.minimumLevel.shouldOmit(Level.DEBUG)) {
            return;
        }
        this.delegate.debug(format, arg);
    }

    @Override
    public void debug(String format, Object ... args) {
        if (this.minimumLevel.shouldOmit(Level.DEBUG)) {
            return;
        }
        this.delegate.debug(format, args);
    }

    @Override
    public void debug(String msg, Throwable t) {
        if (this.minimumLevel.shouldOmit(Level.DEBUG)) {
            return;
        }
        this.delegate.debug(msg, t);
    }

    @Override
    public void info(String msg) {
        if (this.minimumLevel.shouldOmit(Level.INFO)) {
            return;
        }
        this.delegate.info(msg);
    }

    @Override
    public void info(String format, Object arg) {
        if (this.minimumLevel.shouldOmit(Level.INFO)) {
            return;
        }
        this.delegate.info(format, arg);
    }

    @Override
    public void info(String format, Object ... args) {
        if (this.minimumLevel.shouldOmit(Level.INFO)) {
            return;
        }
        this.delegate.info(format, args);
    }

    @Override
    public void info(String msg, Throwable t) {
        if (this.minimumLevel.shouldOmit(Level.INFO)) {
            return;
        }
        this.delegate.info(msg, t);
    }

    @Override
    public void warn(String msg) {
        if (this.minimumLevel.shouldOmit(Level.WARN)) {
            return;
        }
        this.delegate.warn(msg);
    }

    @Override
    public void warn(String format, Object arg) {
        if (this.minimumLevel.shouldOmit(Level.WARN)) {
            return;
        }
        this.delegate.warn(format, arg);
    }

    @Override
    public void warn(String format, Object ... args) {
        if (this.minimumLevel.shouldOmit(Level.WARN)) {
            return;
        }
        this.delegate.warn(format, args);
    }

    @Override
    public void warn(String msg, Throwable t) {
        if (this.minimumLevel.shouldOmit(Level.WARN)) {
            return;
        }
        this.delegate.warn(msg, t);
    }

    @Override
    public void error(String msg) {
        if (this.minimumLevel.shouldOmit(Level.ERROR)) {
            return;
        }
        this.delegate.error(msg);
    }

    @Override
    public void error(String format, Object arg) {
        if (this.minimumLevel.shouldOmit(Level.ERROR)) {
            return;
        }
        this.delegate.error(format, arg);
    }

    @Override
    public void error(String format, Object ... args) {
        if (this.minimumLevel.shouldOmit(Level.ERROR)) {
            return;
        }
        this.delegate.error(format, args);
    }

    @Override
    public void error(String msg, Throwable t) {
        if (this.minimumLevel.shouldOmit(Level.ERROR)) {
            return;
        }
        this.delegate.error(msg, t);
    }

    @Override
    public String format(String format, Object arg) {
        return this.delegate.format(format, arg);
    }

    @Override
    public String format(String format, Object ... args) {
        return this.delegate.format(format, args);
    }

    @Override
    public String format(String msg, Throwable t) {
        return this.delegate.format(msg, t);
    }

    public Logger getDelegate() {
        return this.delegate;
    }

    @Override
    public void setMinimumLevel(Level minimumLevel) {
        this.minimumLevel = Objects.requireNonNull(minimumLevel);
    }

    public Level getMinimumLevel() {
        return this.minimumLevel;
    }
}

