/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.commons.data.impl.node;

import io.gitlab.jfronny.commons.data.impl.node.CharSequenceNodeLeafVoidValue;
import io.gitlab.jfronny.commons.data.impl.node.CharSequenceNodeLeafWithValue;
import io.gitlab.jfronny.commons.data.impl.node.CharSequenceNodeNonLeafVoidValue;
import io.gitlab.jfronny.commons.data.impl.node.CharSequenceNodeNonLeafWithValue;
import io.gitlab.jfronny.commons.data.impl.util.NodeUtil;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public abstract class Node<T>
implements Serializable,
Comparable<Node<T>> {
    private final CharSequence incomingEdgeCharSequence;

    public static <T> Node<T> of(CharSequence edgeCharacters, T value, List<Node<T>> children, boolean isRoot) {
        NodeUtil.precheckCreation(edgeCharacters, children, isRoot);
        Objects.requireNonNull(value, "Use the other factory method for nodes without values!");
        if (children.isEmpty()) {
            return new CharSequenceNodeLeafWithValue<T>(edgeCharacters, value);
        }
        return new CharSequenceNodeNonLeafWithValue<T>(edgeCharacters, value, children);
    }

    public static <T> Node<T> of(CharSequence edgeCharacters, List<Node<T>> children, boolean isRoot) {
        NodeUtil.precheckCreation(edgeCharacters, children, isRoot);
        if (children.isEmpty()) {
            return new CharSequenceNodeLeafVoidValue(edgeCharacters);
        }
        return new CharSequenceNodeNonLeafVoidValue<T>(edgeCharacters, children);
    }

    public Node(CharSequence edgeCharSequence) {
        this.incomingEdgeCharSequence = edgeCharSequence;
    }

    public CharSequence getIncomingEdge() {
        return this.incomingEdgeCharSequence;
    }

    public Character getIncomingEdgeFirstCharacter() {
        return Character.valueOf(this.incomingEdgeCharSequence.charAt(0));
    }

    protected abstract String getValueString();

    public String toString() {
        return "Node{edge=" + this.getIncomingEdge() + ", value=" + this.getValueString() + ", edges=" + this.getOutgoingEdges() + "}";
    }

    @Override
    public int compareTo(@NotNull Node<T> o) {
        return String.valueOf(this.getIncomingEdge()).compareTo(String.valueOf(o.getIncomingEdge()));
    }

    public abstract T getValue();

    public abstract boolean hasValue();

    public abstract Node<T> getOutgoingEdge(Character var1);

    public abstract void updateOutgoingEdge(Node<T> var1);

    public abstract List<Node<T>> getOutgoingEdges();

    public Node<T> copyWithEdgeCharacters(CharSequence edgeCharacters, boolean isRoot) {
        return this.hasValue() ? Node.of(edgeCharacters, this.getValue(), this.getOutgoingEdges(), isRoot) : Node.of(edgeCharacters, this.getOutgoingEdges(), isRoot);
    }

    public Node<T> copyWithoutValue(boolean isRoot) {
        return Node.of(this.getIncomingEdge(), this.getOutgoingEdges(), isRoot);
    }

    public Node<T> copyWithChildren(List<Node<T>> children, boolean isRoot) {
        return this.hasValue() ? Node.of(this.getIncomingEdge(), this.getValue(), children, isRoot) : Node.of(this.getIncomingEdge(), children, isRoot);
    }

    public String prettyPrint() {
        StringBuilder sb = new StringBuilder();
        this.prettyPrint(sb, "", true, true);
        return sb.toString();
    }

    protected void prettyPrint(Appendable sb, String prefix, boolean isTail, boolean isRoot) {
        try {
            StringBuilder label = new StringBuilder();
            if (isRoot) {
                label.append("\u25cb");
                if (!this.getIncomingEdge().isEmpty()) {
                    label.append(" ");
                }
            }
            label.append(this.getIncomingEdge());
            if (this.hasValue()) {
                label.append(" (").append(this.getValue()).append(")");
            }
            sb.append(prefix).append(isTail ? (isRoot ? "" : "\u2514\u2500\u2500 \u25cb ") : "\u251c\u2500\u2500 \u25cb ").append(label).append("\n");
            List<Node<T>> children = this.getOutgoingEdges();
            for (int i = 0; i < children.size() - 1; ++i) {
                children.get(i).prettyPrint(sb, prefix + (isTail ? (isRoot ? "" : "    ") : "\u2502   "), false, false);
            }
            if (!children.isEmpty()) {
                children.get(children.size() - 1).prettyPrint(sb, prefix + (isTail ? (isRoot ? "" : "    ") : "\u2502   "), true, false);
            }
        }
        catch (IOException ioException) {
            throw new IllegalStateException(ioException);
        }
    }
}

