/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.commons.concurrent;

import io.gitlab.jfronny.commons.SamWithReceiver;
import io.gitlab.jfronny.commons.concurrent.AsyncRequestState;
import io.gitlab.jfronny.commons.concurrent.VoidFuture;
import io.gitlab.jfronny.commons.ref.R;
import java.util.Objects;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.function.Consumer;

public class AsyncRequest {
    private final Action action;
    private final Runnable finalize;
    private final AsyncRequestState state = new AsyncRequestState();
    private Future<Void> future = null;

    public AsyncRequest(Action action, Runnable finalize) {
        this.action = Objects.requireNonNull(action);
        this.finalize = Objects.requireNonNull(finalize);
    }

    public AsyncRequest(Consumer<Context> runnable) {
        this.action = (context, callback) -> new VoidFuture(ForkJoinPool.commonPool().submit(() -> {
            runnable.accept(context);
            callback.run();
        }));
        this.finalize = R::nop;
    }

    public void request() {
        if (this.state.request().shouldStart()) {
            this.start();
        }
    }

    private void start() {
        final Future[] tasks = new Future[]{};
        tasks[0] = this.action.schedule(new Context(){

            @Override
            public boolean isCancelled() {
                return tasks[0].isCancelled();
            }
        }, () -> {
            if (!tasks[0].isCancelled()) {
                this.finalize.run();
                this.future = null;
            }
            if (this.state.emitFinished().shouldContinue()) {
                this.start();
            }
        });
        this.future = tasks[0];
    }

    public void cancel() {
        if (this.future != null) {
            this.future.cancel(false);
        }
        this.state.cancel();
    }

    @SamWithReceiver
    public static interface Action {
        public Future<Void> schedule(Context var1, Runnable var2);
    }

    public static interface Context {
        public boolean isCancelled();
    }
}

