/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.commons;

import java.util.Objects;
import java.util.function.Supplier;

public final class OnceSupplier<T>
implements Supplier<T> {
    private final T value;
    private boolean supplied = false;

    public OnceSupplier(T value) {
        this.value = value;
    }

    @Override
    public T get() {
        if (this.supplied) {
            throw new IllegalStateException("Attempted to use already used OnceSupplier");
        }
        this.supplied = true;
        return this.value;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof OnceSupplier)) {
            return false;
        }
        OnceSupplier that = (OnceSupplier)obj;
        return Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }
}

