/*
 * Decompiled with CFR 0.152.
 */
package dev.onyxstudios.cca.internal.item;

import com.google.common.collect.Iterables;
import dev.onyxstudios.cca.api.v3.component.Component;
import dev.onyxstudios.cca.api.v3.component.ComponentContainer;
import dev.onyxstudios.cca.api.v3.component.ComponentFactory;
import dev.onyxstudios.cca.api.v3.component.ComponentKey;
import dev.onyxstudios.cca.api.v3.component.TransientComponent;
import dev.onyxstudios.cca.api.v3.item.ItemComponent;
import dev.onyxstudios.cca.api.v3.item.ItemComponentFactoryRegistry;
import dev.onyxstudios.cca.api.v3.item.ItemComponentInitializer;
import dev.onyxstudios.cca.internal.base.LazyDispatcher;
import dev.onyxstudios.cca.internal.base.asm.CcaAsmHelper;
import dev.onyxstudios.cca.internal.base.asm.StaticComponentPluginBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public final class StaticItemComponentPlugin
extends LazyDispatcher
implements ItemComponentFactoryRegistry {
    public static final StaticItemComponentPlugin INSTANCE = new StaticItemComponentPlugin();
    private final List<PredicatedComponentFactory<?>> dynamicFactories = new ArrayList();
    private final Map<@Nullable class_2960, // Could not load outer class - annotation placement on inner may be incorrect
    ComponentContainer.Factory.Builder<class_1799>> componentFactories = new HashMap<class_2960, ComponentContainer.Factory.Builder<class_1799>>();
    private final ComponentContainer.Factory<class_1799> emptyFactory = stack -> ComponentContainer.EMPTY;

    private StaticItemComponentPlugin() {
        super("creating an ItemStack");
    }

    private static String getSuffix(class_2960 itemId) {
        return "ItemStackImpl_" + CcaAsmHelper.getJavaIdentifierName((class_2960)itemId);
    }

    public static ComponentContainer.Factory<class_1799> createItemStackContainerFactory(class_1792 item) {
        class_2960 itemId = class_7923.field_41178.method_10221((Object)item);
        return INSTANCE.getFactoryClass(item, itemId);
    }

    public ComponentContainer.Factory<class_1799> getFactoryClass(class_1792 item, class_2960 itemId) {
        this.ensureInitialized();
        Objects.requireNonNull(item);
        for (PredicatedComponentFactory<?> dynamicFactory : this.dynamicFactories) {
            dynamicFactory.tryRegister(item, itemId);
        }
        if (this.componentFactories.containsKey(itemId)) {
            return this.componentFactories.get(itemId).factoryNameSuffix(StaticItemComponentPlugin.getSuffix(itemId)).build();
        }
        return this.emptyFactory;
    }

    protected void init() {
        StaticComponentPluginBase.processInitializers((Collection)StaticComponentPluginBase.getComponentEntrypoints((String)"cardinal-components-item", ItemComponentInitializer.class), initializer -> initializer.registerItemComponentFactories(this));
    }

    public <C extends Component> void registerFor(class_2960 itemId, ComponentKey<C> type, ComponentFactory<class_1799, ? extends C> factory) {
        this.checkLoading(ItemComponentFactoryRegistry.class, "register");
        this.register0(itemId, type, factory);
    }

    public <C extends Component> void registerFor(class_1792 item, ComponentKey<C> type, ComponentFactory<class_1799, ? extends C> factory) {
        if (!Iterables.contains((Iterable)class_7923.field_41178, (Object)item)) {
            throw new IllegalStateException(item + " must be registered to Registry.ITEM before using it for component registration");
        }
        class_2960 id = class_7923.field_41178.method_10221((Object)item);
        this.registerFor(id, type, factory);
    }

    @Override
    public <C extends ItemComponent> void register(Predicate<class_1792> test, ComponentKey<? super C> type, ComponentFactory<class_1799, C> factory) {
        this.registerFor(test, type, ItemComponent.wrapFactory(type, factory));
    }

    @Override
    public <C extends ItemComponent> void register(class_1792 item, ComponentKey<? super C> type, ComponentFactory<class_1799, C> factory) {
        this.registerFor(item, type, ItemComponent.wrapFactory(type, factory));
    }

    @Override
    public <C extends TransientComponent> void registerTransient(Predicate<class_1792> test, ComponentKey<? super C> type, ComponentFactory<class_1799, C> factory) {
        this.registerFor(test, type, factory);
    }

    @Override
    public <C extends TransientComponent> void registerTransient(class_1792 item, ComponentKey<? super C> type, ComponentFactory<class_1799, C> factory) {
        this.registerFor(item, type, factory);
    }

    private <C extends Component> void registerFor(Predicate<class_1792> test, ComponentKey<C> type, ComponentFactory<class_1799, ? extends C> factory) {
        this.dynamicFactories.add(new PredicatedComponentFactory<C>(test, type, factory));
    }

    private <C extends Component> void register0(class_2960 itemId, ComponentKey<C> type, ComponentFactory<class_1799, ? extends C> factory) {
        Objects.requireNonNull(itemId);
        ComponentContainer.Factory.Builder builder = this.componentFactories.computeIfAbsent(itemId, t -> ComponentContainer.Factory.builder(class_1799.class));
        builder.checkDuplicate(type, previousFactory -> "Duplicate factory declarations for " + type.getId() + " on item '" + itemId + "': " + factory + " and " + previousFactory);
        builder.component(type, factory);
    }

    private final class PredicatedComponentFactory<C extends Component> {
        private final Predicate<class_1792> predicate;
        private final ComponentKey<C> type;
        private final ComponentFactory<class_1799, ? extends C> factory;

        public PredicatedComponentFactory(Predicate<class_1792> predicate, ComponentKey<C> type, ComponentFactory<class_1799, ? extends C> factory) {
            this.type = type;
            this.factory = factory;
            this.predicate = predicate;
        }

        public void tryRegister(class_1792 item, class_2960 id) {
            if (this.predicate.test(item)) {
                StaticItemComponentPlugin.this.register0(id, this.type, this.factory);
            }
        }
    }
}

