/*
 * Decompiled with CFR 0.152.
 */
package io.github.mattidragon.configloader.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.mattidragon.configloader.api.ConfigManager;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Optional;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.fabricmc.loader.api.FabricLoader;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigManagerImpl<D>
implements ConfigManager<D> {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"ConfigLoader/ConfigManagerImpl");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final Event<ConfigManager.OnLoadCallback<D>> onChange = EventFactory.createArrayBacked(ConfigManager.OnLoadCallback.class, listeners -> config -> {
        for (ConfigManager.OnLoadCallback listener : listeners) {
            listener.onChange(config);
        }
    });
    private final Codec<D> codec;
    private final D defaultValue;
    private final Path path;
    private final String id;
    private boolean overridden = false;
    private boolean prepared = false;
    private D value;

    public ConfigManagerImpl(Codec<D> codec, D defaultValue, String id) {
        this.codec = codec;
        this.defaultValue = defaultValue;
        this.id = id;
        this.path = FabricLoader.getInstance().getConfigDir().resolve(id + ".json");
        this.value = defaultValue;
    }

    @Override
    @NotNull
    public D get() {
        if (System.getProperty("fabric-api.datagen") != null || System.getProperty("fabric-api.gametest") != null) {
            return this.defaultValue;
        }
        this.prepare();
        return this.value;
    }

    @Override
    public void set(@NotNull D config) {
        if (this.overridden) {
            LOGGER.error("Tried to set config {} while overridden", (Object)this.id);
            throw new IllegalStateException("Tried to set config %s while overridden".formatted(this.id));
        }
        this.value = config;
        ((ConfigManager.OnLoadCallback)this.onChange.invoker()).onChange(config);
        this.save();
    }

    @Override
    public Optional<RuntimeException> reload() {
        try {
            this.load();
            return Optional.empty();
        }
        catch (RuntimeException e) {
            LOGGER.error("Failed to reload config {}", (Object)this.id, (Object)e);
            return Optional.of(e);
        }
    }

    @Override
    @NotNull
    public Event<ConfigManager.OnLoadCallback<D>> getReloadEvent() {
        return this.onChange;
    }

    @Override
    public @NotNull ConfigManager.OverrideCloser override(@NotNull D config) {
        if (this.overridden) {
            throw new IllegalStateException("Only singe config override allowed");
        }
        this.overridden = true;
        D previous = this.value;
        this.value = config;
        return () -> {
            this.value = previous;
            this.overridden = false;
        };
    }

    private void prepare() {
        if (this.prepared) {
            return;
        }
        this.prepared = true;
        if (Files.exists(this.path, new LinkOption[0])) {
            this.load();
        } else {
            this.save();
        }
    }

    private void save() {
        this.codec.encodeStart((DynamicOps)JsonOps.INSTANCE, this.value).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(this::write);
    }

    private void write(JsonElement data) {
        try (BufferedWriter out = Files.newBufferedWriter(this.path, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
            GSON.toJson(data, (Appendable)out);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to save power networks config", e);
        }
    }

    private void load() {
        try (BufferedReader in = Files.newBufferedReader(this.path, StandardCharsets.UTF_8);){
            JsonObject json = (JsonObject)GSON.fromJson((Reader)in, JsonObject.class);
            DataResult result = this.codec.parse((DynamicOps)JsonOps.INSTANCE, (Object)json);
            this.value = result.mapError(error -> "Failed to load config %s: %s. Delete the file or invalid values to regenerate defaults.".formatted(this.id, error)).getOrThrow(false, arg_0 -> ((Logger)LOGGER).error(arg_0));
            ((ConfigManager.OnLoadCallback)this.onChange.invoker()).onChange(this.value);
            this.codec.encodeStart((DynamicOps)JsonOps.INSTANCE, this.value).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).filter(o -> !json.equals(o)).ifPresent(this::write);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to load config %s due to io error".formatted(this.id), e);
        }
        catch (JsonSyntaxException e) {
            throw new RuntimeException("Config %s has a syntax errors".formatted(this.id), e);
        }
    }
}

