/*
 * Decompiled with CFR 0.152.
 */
package io.github.mattidragon.configloader.impl;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import io.determann.shadow.api.AnnotationTypeChooser;
import io.determann.shadow.api.ElementBacked;
import io.determann.shadow.api.ShadowApi;
import io.determann.shadow.api.ShadowFactory;
import io.determann.shadow.api.ShadowProcessor;
import io.determann.shadow.api.TypeKind;
import io.determann.shadow.api.shadow.Declared;
import io.determann.shadow.api.shadow.Record;
import io.determann.shadow.api.shadow.RecordComponent;
import io.determann.shadow.api.shadow.Shadow;
import io.determann.shadow.api.wrapper.AnnotationValueTypeChooser;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;

@SupportedAnnotationTypes(value={"io.github.mattidragon.configloader.api.GenerateMutable"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_17)
public class ConfigLoaderAnnotationProcessor
extends ShadowProcessor {
    public static final String GENERATE_MUTABLE_ANNOTATION = "io.github.mattidragon.configloader.api.GenerateMutable";

    public void process(ShadowApi api) {
        AnnotationTypeChooser annotated = api.getAnnotatedWith(GENERATE_MUTABLE_ANNOTATION);
        annotated.declaredTypes().stream().filter(shadow -> !shadow.isTypeKind(TypeKind.RECORD)).forEach(shadow -> api.logErrorAt((ElementBacked)shadow, "@GenerateMutable can only be applied to records"));
        for (Record record : annotated.records()) {
            Element element2;
            ClassName sourceInterface = this.getMutable((Declared)record).nestedClass("Source");
            if (((TypeElement)record.getElement()).getInterfaces().stream().map(DeclaredType.class::cast).map(DeclaredType::asElement).map(TypeElement.class::cast).noneMatch(element -> element.getQualifiedName().contentEquals(sourceInterface.canonicalName()) || element.getQualifiedName().contentEquals(String.join((CharSequence)".", sourceInterface.simpleNames())))) {
                api.logErrorAt((ElementBacked)record, "Records with generated mutable versions must implement source interface (%s)".formatted(sourceInterface.canonicalName()));
            }
            if ((element2 = ((TypeElement)record.getElement()).getEnclosingElement()) instanceof TypeElement) {
                TypeElement declared = (TypeElement)element2;
                if (this.hasMutable((Declared)api.getShadowFactory().shadowFromElement((Element)declared))) continue;
            }
            this.writeMutable(record);
        }
    }

    private void writeMutable(Record record) {
        try {
            JavaFile.builder((String)record.getPackage().getQualifiedName(), (TypeSpec)this.generateMutable(record, false)).indent("    ").build().writeTo(record.getApi().getJdkApiContext().getProcessingEnv().getFiler());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private TypeSpec generateMutable(Record record, boolean inner) {
        Boolean useGetters = record.getDirectUsageOfOrThrow(record.getApi().getAnnotationOrThrow(GENERATE_MUTABLE_ANNOTATION)).getValueOrThrow("encapsulateFields").asBoolean();
        List components = record.getRecordComponents();
        String mutableName = "Mutable" + record.getSimpleName();
        TypeName recordTypeName = TypeName.get((TypeMirror)record.getMirror());
        List<FieldSpec> fields = components.stream().map(component -> FieldSpec.builder((TypeName)this.getMutableOrSelf((Shadow<? extends TypeMirror>)component.getType()), (String)component.getSimpleName(), (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{useGetters != false ? Modifier.PRIVATE : Modifier.PUBLIC}).build()).toList();
        List<MethodSpec> getters = components.stream().map(component -> MethodSpec.methodBuilder((String)ConfigLoaderAnnotationProcessor.getGetterName(component)).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(this.getMutableOrSelf((Shadow<? extends TypeMirror>)component.getType())).addStatement("return this.$L", new Object[]{component.getSimpleName()}).build()).toList();
        List<MethodSpec> setters = components.stream().map(component -> MethodSpec.methodBuilder((String)ConfigLoaderAnnotationProcessor.getSetterName(component)).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(this.getMutableOrSelf((Shadow<? extends TypeMirror>)component.getType()), component.getSimpleName(), new Modifier[0]).addStatement("this.$L = $L", new Object[]{component.getSimpleName(), component.getSimpleName()}).build()).toList();
        MethodSpec.Builder constructorBuilder = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).addParameter((TypeName)this.getMutable((Declared)record).nestedClass("Source"), "immutable", new Modifier[0]).addCode((CodeBlock)components.stream().map(component -> {
            Boolean hasMutable = ShadowApi.convert((Shadow)component.getType()).toDeclared().map(this::hasMutable).orElse(false);
            if (hasMutable.booleanValue()) {
                return CodeBlock.of((String)"this.$L = immutable.$L().toMutable();", (Object[])new Object[]{component.getSimpleName(), component.getSimpleName()});
            }
            return CodeBlock.of((String)"this.$L = immutable.$L();", (Object[])new Object[]{component.getSimpleName(), component.getSimpleName()});
        }).collect(CodeBlock.joining((String)"\n")));
        MethodSpec constructor = constructorBuilder.build();
        MethodSpec toImmutable = MethodSpec.methodBuilder((String)"toImmutable").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(recordTypeName).addStatement(CodeBlock.builder().add("return new $T(", new Object[]{recordTypeName}).add((CodeBlock)components.stream().map(component -> {
            Boolean hasMutable = ShadowApi.convert((Shadow)component.getType()).toDeclared().map(this::hasMutable).orElse(false);
            if (hasMutable.booleanValue()) {
                return CodeBlock.of((String)"this.$L.toImmutable()", (Object[])new Object[]{component.getSimpleName()});
            }
            return CodeBlock.of((String)"this.$L", (Object[])new Object[]{component.getSimpleName()});
        }).collect(CodeBlock.joining((String)", "))).add(")", new Object[0]).build()).build();
        List<TypeSpec> innerMutables = ElementFilter.typesIn(((DeclaredType)record.getMirror()).asElement().getEnclosedElements()).stream().map(arg_0 -> ((ShadowFactory)record.getApi().getShadowFactory()).shadowFromElement(arg_0)).map(innerRecord -> this.generateMutable((Record)innerRecord, true)).toList();
        TypeSpec accessInterface = this.createSourceInterface(record);
        TypeSpec.Builder classBuilder = TypeSpec.classBuilder((String)mutableName);
        classBuilder.addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
        if (inner) {
            classBuilder.addModifiers(new Modifier[]{Modifier.STATIC});
        }
        classBuilder.addFields(fields);
        classBuilder.addMethod(constructor).addMethod(toImmutable);
        if (useGetters.booleanValue()) {
            classBuilder.addMethods(getters).addMethods(setters);
        }
        classBuilder.addTypes(innerMutables).addType(accessInterface);
        return classBuilder.build();
    }

    private static String getGetterName(RecordComponent component) {
        Boolean fancy = component.getRecord().getDirectUsageOf(component.getApi().getAnnotationOrThrow(GENERATE_MUTABLE_ANNOTATION)).map(annotationUsage -> annotationUsage.getValueOrThrow("useFancyMethodNames")).map(AnnotationValueTypeChooser::asBoolean).orElse(false);
        String simpleName = component.getSimpleName();
        return fancy != false ? "get" + Character.toUpperCase(simpleName.charAt(0)) + simpleName.substring(1) : simpleName;
    }

    private static String getSetterName(RecordComponent component) {
        Boolean fancy = component.getRecord().getDirectUsageOf(component.getApi().getAnnotationOrThrow(GENERATE_MUTABLE_ANNOTATION)).map(annotationUsage -> annotationUsage.getValueOrThrow("useFancyMethodNames")).map(AnnotationValueTypeChooser::asBoolean).orElse(false);
        String simpleName = component.getSimpleName();
        return fancy != false ? "set" + Character.toUpperCase(simpleName.charAt(0)) + simpleName.substring(1) : simpleName;
    }

    private TypeSpec createSourceInterface(Record record) {
        List<MethodSpec> accessors = record.getRecordComponents().stream().map(RecordComponent::getGetter).map(getter -> MethodSpec.methodBuilder((String)getter.getSimpleName()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns(TypeName.get((TypeMirror)getter.getReturnType().getMirror())).build()).toList();
        MethodSpec toMutable = MethodSpec.methodBuilder((String)"toMutable").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.DEFAULT}).addStatement("return new $T(this)", new Object[]{this.getMutableOrSelf((Shadow<? extends TypeMirror>)record)}).returns(this.getMutableOrSelf((Shadow<? extends TypeMirror>)record)).build();
        return TypeSpec.interfaceBuilder((String)"Source").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.SEALED}).addMethods(accessors).addMethod(toMutable).addPermittedSubclass(TypeName.get((TypeMirror)record.getMirror())).build();
    }

    private boolean hasMutable(Declared declared) {
        return declared.getDirectUsageOf(declared.getApi().getAnnotationOrThrow(GENERATE_MUTABLE_ANNOTATION)).isPresent();
    }

    private TypeName getMutableOrSelf(Shadow<? extends TypeMirror> shadow) {
        Declared declared;
        if (shadow instanceof Declared && this.hasMutable(declared = (Declared)shadow)) {
            return this.getMutable(declared);
        }
        return TypeName.get((TypeMirror)shadow.getMirror());
    }

    private ClassName getMutable(Declared declared) {
        Element element = ((TypeElement)declared.getElement()).getEnclosingElement();
        if (element instanceof TypeElement) {
            TypeElement typeElement = (TypeElement)element;
            Declared outer = (Declared)declared.getApi().getShadowFactory().shadowFromElement((Element)typeElement);
            if (this.hasMutable(outer)) {
                return this.getMutable(outer).nestedClass("Mutable" + declared.getSimpleName());
            }
        }
        return ClassName.get((String)declared.getPackage().getQualifiedName(), (String)("Mutable" + declared.getSimpleName()), (String[])new String[0]);
    }
}

