/*
 * Decompiled with CFR 0.152.
 */
package io.github.mattidragon.configloader.api;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapEncoder;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import com.mojang.serialization.codecs.FieldEncoder;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class DefaultedFieldCodec<A>
extends MapCodec<A> {
    private final Codec<A> codec;
    private final String name;
    private final Supplier<A> defaultSupplier;
    private final MapEncoder<A> encoder;

    private DefaultedFieldCodec(Codec<A> codec, String name, Supplier<A> defaultSupplier) {
        this.codec = codec;
        this.name = name;
        this.defaultSupplier = defaultSupplier;
        this.encoder = new FieldEncoder(name, codec);
    }

    public static <A> MapCodec<A> of(Codec<A> codec, String name, Supplier<A> defaultSupplier) {
        return new DefaultedFieldCodec<A>(codec, name, defaultSupplier);
    }

    public static <A> MapCodec<A> of(Codec<A> codec, String name, A defaultValue) {
        return new DefaultedFieldCodec<Object>(codec, name, () -> defaultValue);
    }

    public <T> Stream<T> keys(DynamicOps<T> ops) {
        return Stream.of(ops.createString(this.name));
    }

    public <T> DataResult<A> decode(DynamicOps<T> ops, MapLike<T> input) {
        Object value = input.get(this.name);
        if (value == null) {
            return DataResult.success(this.defaultSupplier.get());
        }
        return this.codec.parse(ops, value);
    }

    public <T> RecordBuilder<T> encode(A input, DynamicOps<T> ops, RecordBuilder<T> prefix) {
        return this.encoder.encode(input, ops, prefix);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        DefaultedFieldCodec that = (DefaultedFieldCodec)((Object)o);
        if (!this.codec.equals(that.codec)) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        return this.defaultSupplier.equals(that.defaultSupplier);
    }

    public int hashCode() {
        int result = this.codec.hashCode();
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.defaultSupplier.hashCode();
        return result;
    }
}

