/*
 * Decompiled with CFR 0.152.
 */
package io.github.mattidragon.configloader.api;

import com.mojang.serialization.Codec;
import io.github.mattidragon.configloader.impl.ConfigManagerImpl;
import java.util.Optional;
import net.fabricmc.fabric.api.event.Event;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.CheckReturnValue;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public interface ConfigManager<D> {
    @Contract(value="_, _, _ -> new")
    @NotNull
    public static <D> ConfigManager<D> create(@NotNull Codec<D> codec, @NotNull D defaultValue, @NotNull String id) {
        return new ConfigManagerImpl<D>(codec, defaultValue, id);
    }

    @NotNull
    public D get();

    public void set(@NotNull D var1);

    @CheckReturnValue
    public Optional<RuntimeException> reload();

    @NotNull
    public Event<OnLoadCallback<D>> getReloadEvent();

    @NotNull
    public OverrideCloser override(@NotNull D var1);

    @FunctionalInterface
    public static interface OnLoadCallback<D> {
        public void onChange(D var1);
    }

    @ApiStatus.NonExtendable
    public static interface OverrideCloser
    extends AutoCloseable {
        @Override
        public void close();
    }
}

