/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.polymer.common.api;

import eu.pb4.polymer.common.api.events.SimpleEvent;
import eu.pb4.polymer.common.impl.CommonImpl;
import eu.pb4.polymer.common.impl.CommonImplUtils;
import eu.pb4.polymer.common.impl.CommonResourcePackInfoHolder;
import eu.pb4.polymer.common.impl.CompatStatus;
import eu.pb4.polymer.common.impl.FakeWorld;
import eu.pb4.polymer.common.impl.client.ClientUtils;
import eu.pb4.polymer.common.impl.compat.FloodGateUtils;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1937;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.packettweaker.PacketContext;

public final class PolymerCommonUtils {
    public static final SimpleEvent<ResourcePackChangeCallback> ON_RESOURCE_PACK_STATUS_CHANGE = new SimpleEvent();
    private static Path cachedClientPath;
    private static final String SAFE_CLIENT_SHA1 = "e575a48efda46cf88111ba05b624ef90c520eef1";
    private static final String SAFE_CLIENT_URL = "https://piston-data.mojang.com/v1/objects/e575a48efda46cf88111ba05b624ef90c520eef1/client.jar";
    private static Path cachedClientJarRoot;

    private PolymerCommonUtils() {
    }

    @Nullable
    public static Path getClientJarRoot() {
        Path source;
        if (cachedClientJarRoot != null) {
            return cachedClientJarRoot;
        }
        if (CommonImpl.IS_CLIENT) {
            ModContainer container = (ModContainer)FabricLoader.getInstance().getModContainer("minecraft").get();
            for (Path x : container.getRootPaths()) {
                if (!Files.exists(x.resolve("assets"), new LinkOption[0])) continue;
                cachedClientJarRoot = x;
                return x;
            }
        }
        if ((source = PolymerCommonUtils.getClientJar()) == null) {
            return null;
        }
        try {
            FileSystem fs = FileSystems.newFileSystem(source);
            for (Path x : fs.getRootDirectories()) {
                if (!Files.exists(x.resolve("assets"), new LinkOption[0])) continue;
                cachedClientJarRoot = x;
                return x;
            }
            fs.close();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static Path getClientJar() {
        if (cachedClientPath != null) {
            return cachedClientPath;
        }
        try {
            Path clientJarPath;
            URI clientFile;
            Path clientJarPath2;
            if (CommonImpl.IS_CLIENT && Files.exists(clientJarPath2 = Path.of(clientFile = MinecraftServer.class.getProtectionDomain().getCodeSource().getLocation().toURI()), new LinkOption[0])) {
                try (FileSystem fs = FileSystems.newFileSystem(clientJarPath2);){
                    if (Files.exists(fs.getPath("/", new String[0]), new LinkOption[0])) {
                        Path path = cachedClientPath = clientJarPath2;
                        return path;
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
            if (!Files.exists(clientJarPath = CommonImpl.getGameDir().resolve("polymer/cached_client_jars/e575a48efda46cf88111ba05b624ef90c520eef1.jar"), new LinkOption[0])) {
                Files.createDirectories(clientJarPath.getParent(), new FileAttribute[0]);
                CommonImpl.LOGGER.info("Downloading vanilla client jar...");
                URL url = new URL(SAFE_CLIENT_URL);
                URLConnection connection = url.openConnection();
                InputStream is = connection.getInputStream();
                Files.copy(is, clientJarPath, new CopyOption[0]);
            }
            cachedClientPath = clientJarPath;
            return clientJarPath;
        }
        catch (Exception e) {
            CommonImpl.LOGGER.error("Couldn't retrieve client jar!", (Throwable)e);
            return null;
        }
    }

    public static void executeWithPlayerContext(class_3222 player, Runnable runnable) {
        class_3222 oldPlayer = CommonImplUtils.getPlayer();
        class_3222 oldTarget = PacketContext.get().getTarget();
        CommonImplUtils.setPlayer(player);
        PacketContext.setContext((class_3244)player.field_13987);
        runnable.run();
        CommonImplUtils.setPlayer(oldPlayer);
        PacketContext.setContext((class_3244)(oldTarget != null ? oldTarget.field_13987 : null));
    }

    public static class_1937 getFakeWorld() {
        return FakeWorld.INSTANCE;
    }

    @Nullable
    public static class_3222 getPlayerContext() {
        class_3222 player = PolymerCommonUtils.getPlayerContextNoClient();
        if (player == null && CommonImpl.IS_CLIENT) {
            player = ClientUtils.getPlayer();
        }
        return player;
    }

    @Nullable
    public static class_3222 getPlayerContextNoClient() {
        class_3222 player = PacketContext.get().getTarget();
        if (player == null) {
            player = CommonImplUtils.getPlayer();
        }
        return player;
    }

    public static boolean isNetworkingThread() {
        return Thread.currentThread().getName().startsWith("Netty");
    }

    public static boolean isBedrockPlayer(class_3222 player) {
        if (CompatStatus.FLOODGATE) {
            return FloodGateUtils.isPlayerBroken(player);
        }
        return false;
    }

    public static boolean hasResourcePack(@Nullable class_3222 player) {
        return CommonImpl.FORCE_RESOURCEPACK_ENABLED_STATE || player != null && ((CommonResourcePackInfoHolder)player).polymerCommon$hasResourcePack() || player != null && ((CommonResourcePackInfoHolder)player).polymerCommon$hasResourcePack() || CommonImpl.IS_CLIENT && ClientUtils.isResourcePackLoaded();
    }

    public static boolean isServerBound() {
        if (CommonImpl.IS_CLIENT) {
            return ClientUtils.isSingleplayer();
        }
        return true;
    }

    public static interface ResourcePackChangeCallback {
        public void onResourcePackChange(class_3244 var1, boolean var2, boolean var3);
    }
}

