/*
 * Decompiled with CFR 0.152.
 */
package de.ambertation.wunderlib.math.sdf.shapes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.ambertation.wunderlib.math.Float3;
import de.ambertation.wunderlib.math.Transform;
import de.ambertation.wunderlib.math.sdf.SDF;
import de.ambertation.wunderlib.math.sdf.interfaces.Rotatable;
import de.ambertation.wunderlib.math.sdf.shapes.BaseShape;
import net.minecraft.class_7243;

public class Box
extends BaseShape
implements Rotatable {
    public static final Transform DEFAULT_TRANSFORM = Transform.of(Float3.of(0.0, 0.0, 0.0), Float3.of(8.0, 5.0, 5.0));
    public static final Codec<Box> DIRECT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Transform.CODEC.fieldOf("transform").orElse((Object)Transform.IDENTITY).forGetter(o -> o.transform), (App)Codec.INT.fieldOf("material").orElse((Object)0).forGetter(BaseShape::getMaterialIndex)).apply((Applicative)instance, Box::new));
    public static final class_7243<Box> CODEC = class_7243.method_42115(DIRECT_CODEC);

    @Override
    public class_7243<? extends SDF> codec() {
        return CODEC;
    }

    public Box(Transform t, int matIndex) {
        super(t, matIndex);
    }

    public Box(Float3 center, Float3 size) {
        this(Transform.of(center, size), 0);
    }

    @Override
    public double dist(Float3 pos) {
        pos = this.getParentTransformMatrix().inverted().transform(pos);
        Float3 q = pos.sub(this.getCenter()).unRotate(this.transform.rotation).abs().sub(this.getSize().sub(1.0).div(2.0));
        return q.max(0.0).length() + Math.min(Math.max(q.x, Math.max(q.y, q.z)), 0.0);
    }

    public Float3 getSize() {
        return this.transform.size;
    }

    @Override
    public Transform defaultTransform() {
        return DEFAULT_TRANSFORM;
    }
}

