/*
 * Decompiled with CFR 0.152.
 */
package de.ambertation.wunderlib.math;

import de.ambertation.wunderlib.math.Bounds;
import de.ambertation.wunderlib.math.Float3;
import de.ambertation.wunderlib.math.Float4;
import de.ambertation.wunderlib.math.Quaternion;

public class Matrix4 {
    public static final Matrix4 IDENTITY = new Matrix4(new double[]{1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0});
    public static final int M00 = 0;
    public static final int M01 = 1;
    public static final int M02 = 2;
    public static final int M03 = 3;
    public static final int M10 = 4;
    public static final int M11 = 5;
    public static final int M12 = 6;
    public static final int M13 = 7;
    public static final int M20 = 8;
    public static final int M21 = 9;
    public static final int M22 = 10;
    public static final int M23 = 11;
    public static final int M30 = 12;
    public static final int M31 = 13;
    public static final int M32 = 14;
    public static final int M33 = 15;
    public static final int R0C0 = 0;
    public static final int R0C1 = 1;
    public static final int R0C2 = 2;
    public static final int R0C3 = 3;
    public static final int R1C0 = 4;
    public static final int R1C1 = 5;
    public static final int R1C2 = 6;
    public static final int R1C3 = 7;
    public static final int R2C0 = 8;
    public static final int R2C1 = 9;
    public static final int R2C2 = 10;
    public static final int R2C3 = 11;
    public static final int R3C0 = 12;
    public static final int R3C1 = 13;
    public static final int R3C2 = 14;
    public static final int R3C3 = 15;
    private final double[] m;

    protected Matrix4(double[] inN) {
        this.m = inN;
    }

    public static Matrix4 copyOf(double[] newM) {
        double[] copyM = new double[16];
        System.arraycopy(newM, 0, copyM, 0, copyM.length);
        return new Matrix4(copyM);
    }

    public static Matrix4 of(double[] newM) {
        return new Matrix4(newM);
    }

    public static Matrix4 ofRotation(Quaternion unitLength) {
        double[] newM = new double[16];
        double qw2 = unitLength.w * unitLength.w;
        double qx2 = unitLength.v.x * unitLength.v.x;
        double qy2 = unitLength.v.y * unitLength.v.y;
        double qz2 = unitLength.v.z * unitLength.v.z;
        newM[0] = qx2 - qy2 - qz2 + qw2;
        newM[5] = -qx2 + qy2 - qz2 + qw2;
        newM[10] = -qx2 - qy2 + qz2 + qw2;
        newM[15] = 1.0;
        double tmp1 = unitLength.v.x * unitLength.v.y;
        double tmp2 = unitLength.v.z * unitLength.w;
        newM[4] = 2.0 * (tmp1 + tmp2);
        newM[1] = 2.0 * (tmp1 - tmp2);
        tmp1 = unitLength.v.x * unitLength.v.z;
        tmp2 = unitLength.v.y * unitLength.w;
        newM[8] = 2.0 * (tmp1 - tmp2);
        newM[2] = 2.0 * (tmp1 + tmp2);
        tmp1 = unitLength.v.y * unitLength.v.z;
        tmp2 = unitLength.v.x * unitLength.w;
        newM[9] = 2.0 * (tmp1 + tmp2);
        newM[6] = 2.0 * (tmp1 - tmp2);
        return new Matrix4(newM);
    }

    public static Matrix4 ofTranslation(Float3 t) {
        double[] newM = new double[16];
        newM[0] = 1.0;
        newM[5] = 1.0;
        newM[10] = 1.0;
        newM[15] = 1.0;
        if (t != null) {
            newM[3] = t.x;
            newM[7] = t.y;
            newM[11] = t.z;
        }
        return new Matrix4(newM);
    }

    public static Matrix4 ofScale(Float3 s) {
        double[] newM = new double[16];
        newM[0] = s.x;
        newM[5] = s.y;
        newM[10] = s.z;
        newM[15] = 1.0;
        return new Matrix4(newM);
    }

    public static Matrix4 ofBasis(Float3 xAxis, Float3 yAxis, Float3 zAxis) {
        double[] newM = new double[16];
        newM[0] = xAxis.x;
        newM[4] = xAxis.y;
        newM[8] = xAxis.z;
        newM[12] = 0.0;
        newM[1] = yAxis.x;
        newM[5] = yAxis.y;
        newM[9] = yAxis.z;
        newM[13] = 0.0;
        newM[2] = zAxis.x;
        newM[6] = zAxis.y;
        newM[10] = zAxis.z;
        newM[14] = 0.0;
        newM[15] = 1.0;
        return new Matrix4(newM);
    }

    public Float3 getBasisX() {
        return this.getUnitCubeCorner(Bounds.Interpolate.MAX_MIN_MIN, false).sub(this.getUnitCubeCorner(Bounds.Interpolate.MIN_MIN_MIN, false)).normalized();
    }

    public Float3 getBasisY() {
        return this.getUnitCubeCorner(Bounds.Interpolate.MIN_MAX_MIN, false).sub(this.getUnitCubeCorner(Bounds.Interpolate.MIN_MIN_MIN, false)).normalized();
    }

    public Float3 getBasisZ() {
        return this.getUnitCubeCorner(Bounds.Interpolate.MIN_MIN_MAX, false).sub(this.getUnitCubeCorner(Bounds.Interpolate.MIN_MIN_MIN, false)).normalized();
    }

    public Matrix4 transposed() {
        double[] newM = new double[]{this.m[0], this.m[4], this.m[8], this.m[12], this.m[1], this.m[5], this.m[9], this.m[13], this.m[2], this.m[6], this.m[10], this.m[14], this.m[3], this.m[7], this.m[11], this.m[15]};
        return new Matrix4(newM);
    }

    public Matrix4 mul(Matrix4 B) {
        double[] newM = new double[]{this.m[0] * B.m[0] + this.m[1] * B.m[4] + this.m[2] * B.m[8] + this.m[3] * B.m[12], this.m[0] * B.m[1] + this.m[1] * B.m[5] + this.m[2] * B.m[9] + this.m[3] * B.m[13], this.m[0] * B.m[2] + this.m[1] * B.m[6] + this.m[2] * B.m[10] + this.m[3] * B.m[14], this.m[0] * B.m[3] + this.m[1] * B.m[7] + this.m[2] * B.m[11] + this.m[3] * B.m[15], this.m[4] * B.m[0] + this.m[5] * B.m[4] + this.m[6] * B.m[8] + this.m[7] * B.m[12], this.m[4] * B.m[1] + this.m[5] * B.m[5] + this.m[6] * B.m[9] + this.m[7] * B.m[13], this.m[4] * B.m[2] + this.m[5] * B.m[6] + this.m[6] * B.m[10] + this.m[7] * B.m[14], this.m[4] * B.m[3] + this.m[5] * B.m[7] + this.m[6] * B.m[11] + this.m[7] * B.m[15], this.m[8] * B.m[0] + this.m[9] * B.m[4] + this.m[10] * B.m[8] + this.m[11] * B.m[12], this.m[8] * B.m[1] + this.m[9] * B.m[5] + this.m[10] * B.m[9] + this.m[11] * B.m[13], this.m[8] * B.m[2] + this.m[9] * B.m[6] + this.m[10] * B.m[10] + this.m[11] * B.m[14], this.m[8] * B.m[3] + this.m[9] * B.m[7] + this.m[10] * B.m[11] + this.m[11] * B.m[15], this.m[12] * B.m[0] + this.m[13] * B.m[4] + this.m[14] * B.m[8] + this.m[15] * B.m[12], this.m[12] * B.m[1] + this.m[13] * B.m[5] + this.m[14] * B.m[9] + this.m[15] * B.m[13], this.m[12] * B.m[2] + this.m[13] * B.m[6] + this.m[14] * B.m[10] + this.m[15] * B.m[14], this.m[12] * B.m[3] + this.m[13] * B.m[7] + this.m[14] * B.m[11] + this.m[15] * B.m[15]};
        return new Matrix4(newM);
    }

    public Float4 transform(Float4 v) {
        return new Float4(this.m[0] * v.x + this.m[1] * v.y + this.m[2] * v.z + this.m[3] * v.w, this.m[4] * v.x + this.m[5] * v.y + this.m[6] * v.z + this.m[7] * v.w, this.m[8] * v.x + this.m[9] * v.y + this.m[10] * v.z + this.m[11] * v.w, this.m[12] * v.x + this.m[13] * v.y + this.m[14] * v.z + this.m[15] * v.w);
    }

    public Float3 transform(Float3 point) {
        double w = this.m[12] * point.x + this.m[13] * point.y + this.m[14] * point.z + this.m[15];
        return new Float3((this.m[0] * point.x + this.m[1] * point.y + this.m[2] * point.z + this.m[3]) / w, (this.m[4] * point.x + this.m[5] * point.y + this.m[6] * point.z + this.m[7]) / w, (this.m[8] * point.x + this.m[9] * point.y + this.m[10] * point.z + this.m[11]) / w);
    }

    public Float3 transformDirection(Float3 dir) {
        return new Float3(this.m[0] * dir.x + this.m[1] * dir.y + this.m[2] * dir.z, this.m[4] * dir.x + this.m[5] * dir.y + this.m[6] * dir.z, this.m[8] * dir.x + this.m[9] * dir.y + this.m[10] * dir.z);
    }

    public Float3 translation() {
        return Float3.of(this.m[3], this.m[7], this.m[11]);
    }

    public double det() {
        return this.m[3] * this.m[6] * this.m[9] * this.m[12] - this.m[2] * this.m[7] * this.m[9] * this.m[12] - this.m[3] * this.m[5] * this.m[10] * this.m[12] + this.m[1] * this.m[7] * this.m[10] * this.m[12] + this.m[2] * this.m[5] * this.m[11] * this.m[12] - this.m[1] * this.m[6] * this.m[11] * this.m[12] - this.m[3] * this.m[6] * this.m[8] * this.m[13] + this.m[2] * this.m[7] * this.m[8] * this.m[13] + this.m[3] * this.m[4] * this.m[10] * this.m[13] - this.m[0] * this.m[7] * this.m[10] * this.m[13] - this.m[2] * this.m[4] * this.m[11] * this.m[13] + this.m[0] * this.m[6] * this.m[11] * this.m[13] + this.m[3] * this.m[5] * this.m[8] * this.m[14] - this.m[1] * this.m[7] * this.m[8] * this.m[14] - this.m[3] * this.m[4] * this.m[9] * this.m[14] + this.m[0] * this.m[7] * this.m[9] * this.m[14] + this.m[1] * this.m[4] * this.m[11] * this.m[14] - this.m[0] * this.m[5] * this.m[11] * this.m[14] - this.m[2] * this.m[5] * this.m[8] * this.m[15] + this.m[1] * this.m[6] * this.m[8] * this.m[15] + this.m[2] * this.m[4] * this.m[9] * this.m[15] - this.m[0] * this.m[6] * this.m[9] * this.m[15] - this.m[1] * this.m[4] * this.m[10] * this.m[15] + this.m[0] * this.m[5] * this.m[10] * this.m[15];
    }

    public double det3x3() {
        return this.m[0] * this.m[5] * this.m[10] + this.m[1] * this.m[6] * this.m[8] + this.m[2] * this.m[4] * this.m[9] - this.m[0] * this.m[6] * this.m[9] - this.m[1] * this.m[4] * this.m[10] - this.m[2] * this.m[5] * this.m[8];
    }

    public boolean isOrthogonal() {
        return Math.abs(Math.abs(this.det()) - 1.0) < 1.0E-10;
    }

    public Matrix4 inverted() {
        double det = this.det();
        double iDet = 1.0 / det;
        double[] newM = new double[]{(this.m[6] * this.m[11] * this.m[13] - this.m[7] * this.m[10] * this.m[13] + this.m[7] * this.m[9] * this.m[14] - this.m[5] * this.m[11] * this.m[14] - this.m[6] * this.m[9] * this.m[15] + this.m[5] * this.m[10] * this.m[15]) * iDet, (this.m[3] * this.m[10] * this.m[13] - this.m[2] * this.m[11] * this.m[13] - this.m[3] * this.m[9] * this.m[14] + this.m[1] * this.m[11] * this.m[14] + this.m[2] * this.m[9] * this.m[15] - this.m[1] * this.m[10] * this.m[15]) * iDet, (this.m[2] * this.m[7] * this.m[13] - this.m[3] * this.m[6] * this.m[13] + this.m[3] * this.m[5] * this.m[14] - this.m[1] * this.m[7] * this.m[14] - this.m[2] * this.m[5] * this.m[15] + this.m[1] * this.m[6] * this.m[15]) * iDet, (this.m[3] * this.m[6] * this.m[9] - this.m[2] * this.m[7] * this.m[9] - this.m[3] * this.m[5] * this.m[10] + this.m[1] * this.m[7] * this.m[10] + this.m[2] * this.m[5] * this.m[11] - this.m[1] * this.m[6] * this.m[11]) * iDet, (this.m[7] * this.m[10] * this.m[12] - this.m[6] * this.m[11] * this.m[12] - this.m[7] * this.m[8] * this.m[14] + this.m[4] * this.m[11] * this.m[14] + this.m[6] * this.m[8] * this.m[15] - this.m[4] * this.m[10] * this.m[15]) * iDet, (this.m[2] * this.m[11] * this.m[12] - this.m[3] * this.m[10] * this.m[12] + this.m[3] * this.m[8] * this.m[14] - this.m[0] * this.m[11] * this.m[14] - this.m[2] * this.m[8] * this.m[15] + this.m[0] * this.m[10] * this.m[15]) * iDet, (this.m[3] * this.m[6] * this.m[12] - this.m[2] * this.m[7] * this.m[12] - this.m[3] * this.m[4] * this.m[14] + this.m[0] * this.m[7] * this.m[14] + this.m[2] * this.m[4] * this.m[15] - this.m[0] * this.m[6] * this.m[15]) * iDet, (this.m[2] * this.m[7] * this.m[8] - this.m[3] * this.m[6] * this.m[8] + this.m[3] * this.m[4] * this.m[10] - this.m[0] * this.m[7] * this.m[10] - this.m[2] * this.m[4] * this.m[11] + this.m[0] * this.m[6] * this.m[11]) * iDet, (this.m[5] * this.m[11] * this.m[12] - this.m[7] * this.m[9] * this.m[12] + this.m[7] * this.m[8] * this.m[13] - this.m[4] * this.m[11] * this.m[13] - this.m[5] * this.m[8] * this.m[15] + this.m[4] * this.m[9] * this.m[15]) * iDet, (this.m[3] * this.m[9] * this.m[12] - this.m[1] * this.m[11] * this.m[12] - this.m[3] * this.m[8] * this.m[13] + this.m[0] * this.m[11] * this.m[13] + this.m[1] * this.m[8] * this.m[15] - this.m[0] * this.m[9] * this.m[15]) * iDet, (this.m[1] * this.m[7] * this.m[12] - this.m[3] * this.m[5] * this.m[12] + this.m[3] * this.m[4] * this.m[13] - this.m[0] * this.m[7] * this.m[13] - this.m[1] * this.m[4] * this.m[15] + this.m[0] * this.m[5] * this.m[15]) * iDet, (this.m[3] * this.m[5] * this.m[8] - this.m[1] * this.m[7] * this.m[8] - this.m[3] * this.m[4] * this.m[9] + this.m[0] * this.m[7] * this.m[9] + this.m[1] * this.m[4] * this.m[11] - this.m[0] * this.m[5] * this.m[11]) * iDet, (this.m[6] * this.m[9] * this.m[12] - this.m[5] * this.m[10] * this.m[12] - this.m[6] * this.m[8] * this.m[13] + this.m[4] * this.m[10] * this.m[13] + this.m[5] * this.m[8] * this.m[14] - this.m[4] * this.m[9] * this.m[14]) * iDet, (this.m[1] * this.m[10] * this.m[12] - this.m[2] * this.m[9] * this.m[12] + this.m[2] * this.m[8] * this.m[13] - this.m[0] * this.m[10] * this.m[13] - this.m[1] * this.m[8] * this.m[14] + this.m[0] * this.m[9] * this.m[14]) * iDet, (this.m[2] * this.m[5] * this.m[12] - this.m[1] * this.m[6] * this.m[12] - this.m[2] * this.m[4] * this.m[13] + this.m[0] * this.m[6] * this.m[13] + this.m[1] * this.m[4] * this.m[14] - this.m[0] * this.m[5] * this.m[14]) * iDet, (this.m[1] * this.m[6] * this.m[8] - this.m[2] * this.m[5] * this.m[8] + this.m[2] * this.m[4] * this.m[9] - this.m[0] * this.m[6] * this.m[9] - this.m[1] * this.m[4] * this.m[10] + this.m[0] * this.m[5] * this.m[10]) * iDet};
        return new Matrix4(newM);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Float3.toString(this.m[0]));
        sb.append("\t, ");
        sb.append(Float3.toString(this.m[1]));
        sb.append("\t, ");
        sb.append(Float3.toString(this.m[2]));
        sb.append("\t, ");
        sb.append(Float3.toString(this.m[3]));
        sb.append("\n");
        sb.append(Float3.toString(this.m[4]));
        sb.append("\t, ");
        sb.append(Float3.toString(this.m[5]));
        sb.append("\t, ");
        sb.append(Float3.toString(this.m[6]));
        sb.append("\t, ");
        sb.append(Float3.toString(this.m[7]));
        sb.append("\n");
        sb.append(Float3.toString(this.m[8]));
        sb.append("\t, ");
        sb.append(Float3.toString(this.m[9]));
        sb.append("\t, ");
        sb.append(Float3.toString(this.m[10]));
        sb.append("\t, ");
        sb.append(Float3.toString(this.m[11]));
        sb.append("\n");
        sb.append(Float3.toString(this.m[12]));
        sb.append("\t, ");
        sb.append(Float3.toString(this.m[13]));
        sb.append("\t, ");
        sb.append(Float3.toString(this.m[14]));
        sb.append("\t, ");
        sb.append(Float3.toString(this.m[15]));
        sb.append("\n");
        return sb.toString();
    }

    public Float3[] getUnitCubeCornersAndCenter(boolean blockAligned) {
        Float3[] corners = new Float3[Bounds.Interpolate.CORNERS_AND_CENTER.length];
        for (Bounds.Interpolate c : Bounds.Interpolate.CORNERS_AND_CENTER) {
            corners[c.idx.byteValue()] = this.getUnitCubeCorner(c, blockAligned);
        }
        return corners;
    }

    public Float3[] getUnitCubeCorners(boolean blockAligned) {
        Float3[] corners = new Float3[Bounds.Interpolate.CORNERS.length];
        for (Bounds.Interpolate c : Bounds.Interpolate.CORNERS) {
            corners[c.idx.byteValue()] = this.getUnitCubeCorner(c, blockAligned);
        }
        return corners;
    }

    public Float3 getUnitCubeCorner(Bounds.Interpolate corner, boolean blockAligned) {
        return this.transform(Bounds.Interpolate.CORNERS_AND_CENTER[corner.idx.byteValue()].t.sub(0.5)).align(blockAligned);
    }
}

