/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.mixin_extensions.points;

import io.github.fabricators_of_create.porting_lib.mixin_extensions.injectors.wrap_variable.WrapVariableInjector;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.spongepowered.asm.mixin.injection.InjectionPoint;
import org.spongepowered.asm.mixin.injection.struct.InjectionPointData;

@InjectionPoint.AtCode(value="WRAPPABLE")
public class WrappableInjectionPoint
extends InjectionPoint {
    public static final Map<String, Integer> NAME_TO_OPCODE = new HashMap<String, Integer>();
    public static final Set<Integer> ALLOWED_OPCODES = WrapVariableInjector.OPCODE_TYPES.keySet();
    private final int ordinal;
    private final Set<Integer> opcodes;

    public WrappableInjectionPoint(InjectionPointData data) {
        super(data);
        this.ordinal = data.getOrdinal();
        this.opcodes = this.parseOpcodes(data);
    }

    private Set<Integer> parseOpcodes(InjectionPointData data) {
        String opcodesStr = data.get("opcodes", "");
        if (opcodesStr.isEmpty()) {
            return ALLOWED_OPCODES;
        }
        String[] split = opcodesStr.split(",");
        HashSet<Integer> opcodes = new HashSet<Integer>();
        for (String opcodeName : split) {
            Integer opcode = NAME_TO_OPCODE.get(opcodeName);
            if (opcode == null) {
                throw new IllegalArgumentException("Unknown/unsupported opcode: " + opcodeName);
            }
            opcodes.add(opcode);
        }
        return opcodes;
    }

    public boolean find(String desc, InsnList insns, Collection<AbstractInsnNode> nodes) {
        boolean found = false;
        int ordinal = 0;
        for (AbstractInsnNode insn : insns) {
            if (!this.opcodes.contains(insn.getOpcode())) continue;
            if (this.ordinalMatches(ordinal)) {
                nodes.add(insn);
                found = true;
            }
            ++ordinal;
        }
        return found;
    }

    private boolean ordinalMatches(int ordinal) {
        return this.ordinal == -1 || this.ordinal == ordinal;
    }

    static {
        try {
            boolean foundCodes = false;
            for (Field field : Opcodes.class.getFields()) {
                if (!(foundCodes |= field.getName().equals("NOP"))) continue;
                NAME_TO_OPCODE.put(field.getName(), field.getInt(null));
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

