/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.mixin_extensions.injectors.wrap_variable;

import java.util.HashMap;
import java.util.Map;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.InstructionAdapter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.spongepowered.asm.mixin.injection.code.Injector;
import org.spongepowered.asm.mixin.injection.selectors.ISelectorContext;
import org.spongepowered.asm.mixin.injection.struct.InjectionInfo;
import org.spongepowered.asm.mixin.injection.struct.InjectionNodes;
import org.spongepowered.asm.mixin.injection.struct.Target;
import org.spongepowered.asm.mixin.injection.throwables.InvalidInjectionException;

public class WrapVariableInjector
extends Injector {
    public static final Type OBJECT_TYPE = InstructionAdapter.OBJECT_TYPE;
    public static Map<Integer, Type> OPCODE_TYPES = new HashMap<Integer, Type>();

    public WrapVariableInjector(InjectionInfo info) {
        super(info, "@WrapVariable");
    }

    protected void inject(Target target, InjectionNodes.InjectionNode node) {
        this.checkTargetModifiers(target, false);
        AbstractInsnNode targetNode = node.getCurrentTarget();
        Type type = this.getType(targetNode);
        this.assertValidTarget(target, type);
        Injector.InjectorData handler = new Injector.InjectorData(target, "variable wrapper");
        Type returnType = type == OBJECT_TYPE ? this.returnType : type;
        this.validateParams(handler, returnType, new Type[]{returnType});
        InsnList addedInsns = new InsnList();
        if (!this.isStatic) {
            addedInsns.add((AbstractInsnNode)new VarInsnNode(25, 0));
            if (type.getSize() == 2) {
                addedInsns.add((AbstractInsnNode)new InsnNode(91));
                addedInsns.add((AbstractInsnNode)new InsnNode(87));
            } else {
                addedInsns.add((AbstractInsnNode)new InsnNode(95));
            }
        }
        if (handler.captureTargetArgs > 0) {
            Target.Extension stack = target.extendStack();
            this.pushArgs(target.arguments, addedInsns, target.getArgIndices(), 0, handler.captureTargetArgs, stack);
            stack.apply();
        }
        this.invokeHandler(addedInsns);
        target.insns.insert(targetNode, addedInsns);
    }

    protected void assertValidTarget(Target target, Type type) {
        if (type == null) {
            throw new InvalidInjectionException((ISelectorContext)this.info, "@WrapVariable is targeting an invalid instruction in " + target + " in " + this);
        }
    }

    protected Type getType(AbstractInsnNode node) {
        return OPCODE_TYPES.get(node.getOpcode());
    }

    static {
        OPCODE_TYPES.put(25, OBJECT_TYPE);
        OPCODE_TYPES.put(24, Type.DOUBLE_TYPE);
        OPCODE_TYPES.put(23, Type.FLOAT_TYPE);
        OPCODE_TYPES.put(21, Type.INT_TYPE);
        OPCODE_TYPES.put(22, Type.LONG_TYPE);
        OPCODE_TYPES.put(50, OBJECT_TYPE);
        OPCODE_TYPES.put(51, Type.BOOLEAN_TYPE);
        OPCODE_TYPES.put(52, Type.CHAR_TYPE);
        OPCODE_TYPES.put(49, Type.DOUBLE_TYPE);
        OPCODE_TYPES.put(48, Type.FLOAT_TYPE);
        OPCODE_TYPES.put(46, Type.INT_TYPE);
        OPCODE_TYPES.put(47, Type.LONG_TYPE);
        OPCODE_TYPES.put(53, Type.SHORT_TYPE);
        OPCODE_TYPES.put(192, OBJECT_TYPE);
        OPCODE_TYPES.put(133, Type.LONG_TYPE);
        OPCODE_TYPES.put(134, Type.FLOAT_TYPE);
        OPCODE_TYPES.put(135, Type.DOUBLE_TYPE);
        OPCODE_TYPES.put(136, Type.INT_TYPE);
        OPCODE_TYPES.put(137, Type.FLOAT_TYPE);
        OPCODE_TYPES.put(138, Type.DOUBLE_TYPE);
        OPCODE_TYPES.put(139, Type.INT_TYPE);
        OPCODE_TYPES.put(140, Type.FLOAT_TYPE);
        OPCODE_TYPES.put(141, Type.DOUBLE_TYPE);
        OPCODE_TYPES.put(142, Type.INT_TYPE);
        OPCODE_TYPES.put(143, Type.LONG_TYPE);
        OPCODE_TYPES.put(144, Type.FLOAT_TYPE);
        OPCODE_TYPES.put(145, Type.BOOLEAN_TYPE);
        OPCODE_TYPES.put(146, Type.CHAR_TYPE);
        OPCODE_TYPES.put(147, Type.SHORT_TYPE);
    }
}

