/*
 * Decompiled with CFR 0.152.
 */
package me.fzzyhmstrs.fzzy_config.validated_field;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.fzzyhmstrs.fzzy_config.config_util.ValidationResult;
import me.fzzyhmstrs.fzzy_config.validated_field.ValidatedField;
import net.minecraft.class_2540;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B)\u0012\u0006\u0010\u001c\u001a\u00020\u0002\u0012\u000e\b\u0002\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00020\u0019\u0012\b\b\u0002\u0010\u0017\u001a\u00020\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001eJ%\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\u00062\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0002H\u0014\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\u000b\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\tH\u0014\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\r\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u000f\u001a\u00020\u0003H\u0014\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0012\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\tH\u0014\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001d\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0002H\u0014\u00a2\u0006\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0018R\u001a\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00020\u00198\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001f"}, d2={"Lme/fzzyhmstrs/fzzy_config/validated_field/ValidatedString;", "Lme/fzzyhmstrs/fzzy_config/validated_field/ValidatedField;", "", "Lcom/google/gson/JsonElement;", "json", "fieldName", "Lme/fzzyhmstrs/fzzy_config/config_util/ValidationResult;", "deserializeHeldValue", "(Lcom/google/gson/JsonElement;Ljava/lang/String;)Lme/fzzyhmstrs/fzzy_config/config_util/ValidationResult;", "Lnet/minecraft/class_2540;", "buf", "fromBuf", "(Lnet/minecraft/class_2540;)Ljava/lang/String;", "readmeText", "()Ljava/lang/String;", "serializeHeldValue", "()Lcom/google/gson/JsonElement;", "", "toBuf", "(Lnet/minecraft/class_2540;)V", "input", "validateAndCorrectInputs", "(Ljava/lang/String;)Lme/fzzyhmstrs/fzzy_config/config_util/ValidationResult;", "invalidIdMessage", "Ljava/lang/String;", "Ljava/util/function/Predicate;", "strValidator", "Ljava/util/function/Predicate;", "defaultValue", "<init>", "(Ljava/lang/String;Ljava/util/function/Predicate;Ljava/lang/String;)V", "fzzy_config"})
public final class ValidatedString
extends ValidatedField<String> {
    @NotNull
    private final Predicate<String> strValidator;
    @NotNull
    private final String invalidIdMessage;

    public ValidatedString(@NotNull String defaultValue, @NotNull Predicate<String> strValidator, @NotNull String invalidIdMessage) {
        Intrinsics.checkNotNullParameter((Object)defaultValue, (String)"defaultValue");
        Intrinsics.checkNotNullParameter(strValidator, (String)"strValidator");
        Intrinsics.checkNotNullParameter((Object)invalidIdMessage, (String)"invalidIdMessage");
        super(defaultValue);
        this.strValidator = strValidator;
        this.invalidIdMessage = invalidIdMessage;
        if (!this.strValidator.test(defaultValue)) {
            Class<?> clazz = this.getClass().getEnclosingClass();
            throw new IllegalArgumentException("Default string [" + defaultValue + "] not valid per defined strValidator, in [" + this.getClass().getCanonicalName() + "] in config class [" + (String)(clazz == null ? null : clazz.getCanonicalName()) + "]");
        }
    }

    public /* synthetic */ ValidatedString(String string, Predicate predicate, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            predicate = ValidatedString::_init_$lambda-0;
        }
        if ((n & 4) != 0) {
            string2 = "None";
        }
        this(string, predicate, string2);
    }

    @Override
    @NotNull
    protected ValidationResult<String> deserializeHeldValue(@NotNull JsonElement json, @NotNull String fieldName) {
        ValidationResult<Object> validationResult;
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        try {
            validationResult = this.getGson().fromJson(json, String.class);
            Intrinsics.checkNotNullExpressionValue(validationResult, (String)"gson.fromJson(json, String::class.java)");
            validationResult = ValidationResult.Companion.success(validationResult);
        }
        catch (Exception e) {
            validationResult = ValidationResult.Companion.error(this.getStoredValue(), "json [" + json + "] at key " + fieldName + " is not a properly formatted string");
        }
        return validationResult;
    }

    @Override
    @NotNull
    protected JsonElement serializeHeldValue() {
        return (JsonElement)new JsonPrimitive((String)this.getStoredValue());
    }

    @Override
    @NotNull
    protected ValidationResult<String> validateAndCorrectInputs(@NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        if (!this.strValidator.test(input)) {
            String errorMessage = "Config string [" + input + "] couldn't be validated. Needs to meet the following criteria: " + this.invalidIdMessage;
            return ValidationResult.Companion.error(this.getStoredValue(), errorMessage);
        }
        return ValidationResult.Companion.success(input);
    }

    @Override
    @NotNull
    public String readmeText() {
        return "String value that needs to meet the following criteria: " + this.invalidIdMessage;
    }

    @Override
    protected void toBuf(@NotNull class_2540 buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        buf.method_10814((String)this.getStoredValue());
    }

    @Override
    @NotNull
    protected String fromBuf(@NotNull class_2540 buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        String string = buf.method_19772();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"buf.readString()");
        return string;
    }

    private static final boolean _init_$lambda-0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }
}

