/*
 * Decompiled with CFR 0.152.
 */
package me.fzzyhmstrs.fzzy_config.validated_field;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.fzzyhmstrs.fzzy_config.config_util.SyncedConfigHelperV1;
import me.fzzyhmstrs.fzzy_config.config_util.ValidationResult;
import me.fzzyhmstrs.fzzy_config.validated_field.ValidatedField;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0004\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000*\u0012\b\u0000\u0010\u0003*\u00020\u0001*\b\u0012\u0004\u0012\u00028\u00000\u00022\b\u0012\u0004\u0012\u00028\u00000\u0004B/\b\u0004\u0012\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u0016\u0012\u0006\u0010\u0019\u001a\u00028\u0000\u0012\u0006\u0010\u0015\u001a\u00028\u0000\u0012\u0006\u0010\u0013\u001a\u00028\u0000\u00a2\u0006\u0004\b\u001a\u0010\u001bJ%\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\t2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0007H\u0014\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\f\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u000e\u001a\u00020\u0005H\u0014\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001d\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\t2\u0006\u0010\u0010\u001a\u00028\u0000H\u0014\u00a2\u0006\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00028\u00008\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00028\u00008\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0014R\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u00168\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0018\u0082\u0001\u0006\u001c\u001d\u001e\u001f !\u00a8\u0006\""}, d2={"Lme/fzzyhmstrs/fzzy_config/validated_field/ValidatedNumber;", "", "", "T", "Lme/fzzyhmstrs/fzzy_config/validated_field/ValidatedField;", "Lcom/google/gson/JsonElement;", "json", "", "fieldName", "Lme/fzzyhmstrs/fzzy_config/config_util/ValidationResult;", "deserializeHeldValue", "(Lcom/google/gson/JsonElement;Ljava/lang/String;)Lme/fzzyhmstrs/fzzy_config/config_util/ValidationResult;", "readmeText", "()Ljava/lang/String;", "serializeHeldValue", "()Lcom/google/gson/JsonElement;", "input", "validateAndCorrectInputs", "(Ljava/lang/Number;)Lme/fzzyhmstrs/fzzy_config/config_util/ValidationResult;", "maxValue", "Ljava/lang/Number;", "minValue", "Ljava/lang/Class;", "numberClass", "Ljava/lang/Class;", "defaultValue", "<init>", "(Ljava/lang/Class;Ljava/lang/Number;Ljava/lang/Number;Ljava/lang/Number;)V", "Lme/fzzyhmstrs/fzzy_config/validated_field/ValidatedInt;", "Lme/fzzyhmstrs/fzzy_config/validated_field/ValidatedFloat;", "Lme/fzzyhmstrs/fzzy_config/validated_field/ValidatedDouble;", "Lme/fzzyhmstrs/fzzy_config/validated_field/ValidatedLong;", "Lme/fzzyhmstrs/fzzy_config/validated_field/ValidatedShort;", "Lme/fzzyhmstrs/fzzy_config/validated_field/ValidatedByte;", "fzzy_config"})
public abstract class ValidatedNumber<T extends Number>
extends ValidatedField<T> {
    @NotNull
    private final Class<T> numberClass;
    @NotNull
    private final T minValue;
    @NotNull
    private final T maxValue;

    private ValidatedNumber(Class<T> numberClass, T defaultValue, T minValue, T maxValue) {
        super(defaultValue);
        this.numberClass = numberClass;
        this.minValue = minValue;
        this.maxValue = maxValue;
        if (((Comparable)this.minValue).compareTo(this.maxValue) > 0) {
            Class<?> clazz = this.getClass().getEnclosingClass();
            throw new IllegalArgumentException("Min value [" + this.minValue + "] greater than max value [" + this.maxValue + "] in validated number [" + this.getClass().getCanonicalName() + "] in config class [" + (String)(clazz == null ? null : clazz.getCanonicalName()) + "]");
        }
    }

    @Override
    @NotNull
    protected ValidationResult<T> deserializeHeldValue(@NotNull JsonElement json, @NotNull String fieldName) {
        ValidationResult<Object> validationResult;
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        try {
            validationResult = ValidationResult.Companion.success(SyncedConfigHelperV1.INSTANCE.getGson().fromJson(json, this.numberClass));
        }
        catch (Exception e) {
            validationResult = ValidationResult.Companion.error(this.getStoredValue(), "json [" + json + "] at key [" + fieldName + "] is not a properly formatted number");
        }
        ValidationResult<Object> i = validationResult;
        return i;
    }

    @Override
    @NotNull
    protected JsonElement serializeHeldValue() {
        return (JsonElement)new JsonPrimitive((Number)this.getStoredValue());
    }

    @Override
    @NotNull
    protected ValidationResult<T> validateAndCorrectInputs(@NotNull T input) {
        Intrinsics.checkNotNullParameter(input, (String)"input");
        if (((Comparable)input).compareTo(this.minValue) < 0) {
            String errorMessage = "Value {" + input + "} is below the minimum bound of {" + this.minValue + "}.";
            return ValidationResult.Companion.error(this.minValue, errorMessage);
        }
        if (((Comparable)input).compareTo(this.maxValue) > 0) {
            String errorMessage = "Value {" + input + "} is above the maximum bound of {" + this.maxValue + "}.";
            return ValidationResult.Companion.error(this.maxValue, errorMessage);
        }
        return ValidationResult.Companion.success(input);
    }

    @Override
    @NotNull
    public String readmeText() {
        return "Number with a default of " + this.getStoredValue() + ", a minimum of " + this.minValue + ", and a maximum of " + this.maxValue;
    }

    public /* synthetic */ ValidatedNumber(Class numberClass, Number defaultValue, Number minValue, Number maxValue, DefaultConstructorMarker $constructor_marker) {
        this(numberClass, defaultValue, minValue, maxValue);
    }
}

