/*
 * Decompiled with CFR 0.152.
 */
package me.fzzyhmstrs.fzzy_config.validated_field;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.fzzyhmstrs.fzzy_config.config_util.ValidationResult;
import me.fzzyhmstrs.fzzy_config.validated_field.ValidatedField;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u001e\n\u0002\b\u0006\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B)\u0012\u0006\u0010\u001d\u001a\u00020\u0002\u0012\u000e\b\u0002\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00020\u001a\u0012\b\b\u0002\u0010\u0018\u001a\u00020\u0005\u00a2\u0006\u0004\b\u001e\u0010\u001fJ%\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0005H\u0014\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\f\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\nH\u0014\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u000e\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0010\u001a\u00020\u0003H\u0014\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\nH\u0014\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001d\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0002H\u0014\u00a2\u0006\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00020\u001a8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001c\u00a8\u0006 "}, d2={"Lme/fzzyhmstrs/fzzy_config/validated_field/ValidatedIdentifier;", "Lme/fzzyhmstrs/fzzy_config/validated_field/ValidatedField;", "Lnet/minecraft/class_2960;", "Lcom/google/gson/JsonElement;", "json", "", "fieldName", "Lme/fzzyhmstrs/fzzy_config/config_util/ValidationResult;", "deserializeHeldValue", "(Lcom/google/gson/JsonElement;Ljava/lang/String;)Lme/fzzyhmstrs/fzzy_config/config_util/ValidationResult;", "Lnet/minecraft/class_2540;", "buf", "fromBuf", "(Lnet/minecraft/class_2540;)Lnet/minecraft/class_2960;", "readmeText", "()Ljava/lang/String;", "serializeHeldValue", "()Lcom/google/gson/JsonElement;", "", "toBuf", "(Lnet/minecraft/class_2540;)V", "input", "validateAndCorrectInputs", "(Lnet/minecraft/class_2960;)Lme/fzzyhmstrs/fzzy_config/config_util/ValidationResult;", "invalidIdMessage", "Ljava/lang/String;", "", "validIds", "Ljava/util/Collection;", "defaultValue", "<init>", "(Lnet/minecraft/class_2960;Ljava/util/Collection;Ljava/lang/String;)V", "fzzy_config"})
public final class ValidatedIdentifier
extends ValidatedField<class_2960> {
    @NotNull
    private final Collection<class_2960> validIds;
    @NotNull
    private final String invalidIdMessage;

    public ValidatedIdentifier(@NotNull class_2960 defaultValue, @NotNull Collection<? extends class_2960> validIds, @NotNull String invalidIdMessage) {
        Intrinsics.checkNotNullParameter((Object)defaultValue, (String)"defaultValue");
        Intrinsics.checkNotNullParameter(validIds, (String)"validIds");
        Intrinsics.checkNotNullParameter((Object)invalidIdMessage, (String)"invalidIdMessage");
        super(defaultValue);
        this.validIds = validIds;
        this.invalidIdMessage = invalidIdMessage;
        if (!this.validIds.contains(defaultValue) && !this.validIds.isEmpty()) {
            Class<?> clazz = this.getClass().getEnclosingClass();
            throw new IllegalArgumentException("Default identifier [" + defaultValue + "] not valid per defined idValidator in validated identifier [" + this.getClass().getCanonicalName() + "] in config class [" + (String)(clazz == null ? null : clazz.getCanonicalName()) + "]");
        }
    }

    public /* synthetic */ ValidatedIdentifier(class_2960 class_29602, Collection collection, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            collection = CollectionsKt.emptyList();
        }
        if ((n & 4) != 0) {
            string = "None";
        }
        this(class_29602, collection, string);
    }

    @Override
    @NotNull
    protected ValidationResult<class_2960> deserializeHeldValue(@NotNull JsonElement json, @NotNull String fieldName) {
        ValidationResult<class_2960> validationResult;
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        try {
            String string = (String)this.getGson().fromJson(json, String.class);
            class_2960 id = class_2960.method_12829((String)string);
            validationResult = id == null ? ValidationResult.Companion.error(this.getStoredValue(), "Identifier " + id + " couldn't be parsed, resorting to fallback.") : ValidationResult.Companion.success(id);
        }
        catch (Exception e) {
            validationResult = ValidationResult.Companion.error(this.getStoredValue(), "json [" + json + "] at key " + fieldName + " is not a properly formatted string");
        }
        return validationResult;
    }

    @Override
    @NotNull
    protected JsonElement serializeHeldValue() {
        return (JsonElement)new JsonPrimitive(((class_2960)this.getStoredValue()).toString());
    }

    @Override
    @NotNull
    protected ValidationResult<class_2960> validateAndCorrectInputs(@NotNull class_2960 input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        if (!this.validIds.contains(input) && !this.validIds.isEmpty()) {
            String errorMessage = "Config Identifier " + input + " couldn't be validated. Needs to meet the following criteria: " + this.invalidIdMessage;
            return ValidationResult.Companion.error(this.getStoredValue(), errorMessage);
        }
        return ValidationResult.Companion.success(input);
    }

    @Override
    @NotNull
    public String readmeText() {
        return "Identifier stored as a string that needs to meet the following criteria: " + this.invalidIdMessage;
    }

    @Override
    protected void toBuf(@NotNull class_2540 buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        buf.method_10812((class_2960)this.getStoredValue());
    }

    @Override
    @NotNull
    protected class_2960 fromBuf(@NotNull class_2540 buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        class_2960 class_29602 = buf.method_10810();
        Intrinsics.checkNotNullExpressionValue((Object)class_29602, (String)"buf.readIdentifier()");
        return class_29602;
    }
}

